/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.session;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.businessconnector.hub.exception.KmehrBusinessConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType;
import be.fgov.ehealth.hubservices.core.v1.TransactionIdType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;


/**
 * Test for specific case
 * 
 * @author EHP
 */
@Ignore("tests can't run anymore -> at least one part ( creation of sumehr is not supported anymore )")
public class SpecificHubIntegrationTest extends AbstractIntrahubIntegrationTest {

    private static ConsentType consent;

    private static TherapeuticLinkType therapeuticLink;

    // @Rule
    // public SessionRule rule =
    // SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysiotherapist").forUser("hannes").build();


    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionRSW() throws Exception {
        testPutTransaction(HubConfig.URL_RSW, HubConfig.HUBID_RSW, HubConfig.APPID_RSW);
    }


    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    // @Ignore("method not supported by kul")
    public void testSessionPutTransactionKul() throws Exception {
        testPutTransaction(HubConfig.URL_VZNKUL, HubConfig.HUB_ID, HubConfig.APPID_VZNKUL);
    }

    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionCozo() throws Exception {
        testPutTransaction(HubConfig.URL_COZO, HubConfig.HUBID_COZO, HubConfig.APPID_COZO);
    }

    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionARH() throws Exception {
        testPutTransaction(HubConfig.URL_ARH, HubConfig.HUBID_ARH, HubConfig.APPID_ARH);
    }


    /**
     * @throws Exception
     * @throws IntraHubBusinessConnectorException
     * @throws TechnicalConnectorException
     */
    private void testPutTransaction(String url, String hubid, String appid) throws Exception, IntraHubBusinessConnectorException, TechnicalConnectorException {

        // SessionInitializer.init("/be.ehealth.businessconnector.intrahub.test.properties");
        ConfigFactory.getConfigValidator().setProperty("endpoint.hub.intra", url);
        ConfigFactory.getConfigValidator().setProperty(HubConfig.HUB_ID, hubid);
        ConfigFactory.getConfigValidator().setProperty(HubConfig.HUB_APP, appid);

        consent = HubTestHelper.createConsentType();
        HubServiceComplete hubServiceComplete = HubSessionServiceFactory.getHubServiceComplete();
        hubServiceComplete.putPatientConsent(consent);

        therapeuticLink = HubTestHelper.createTherapeuticLinkType();
        hubServiceComplete.putTherapeuticLink(therapeuticLink);

        Kmehrmessage transactionToPut = new Kmehrmessage();
        transactionToPut.setHeader(HubTestHelper.createHeader());
        FolderType folder = new FolderType();
        folder.getIds().add(HubTestHelper.createMessageId("1"));
        folder.setPatient(HubTestHelper.createPatientForTransaction());
        folder.getTransactions().add(HubTestHelper.createTransactionType());
        transactionToPut.getFolders().add(folder);

        // Session.getInstance().unloadSession();

        // try {
        // hubServiceComplete.putTransaction(transactionToPut);
        // Assert.fail("Must throw a 'No active session found' exception");
        // } catch (TechnicalConnectorException e) {
        // Assert.assertEquals("No active session found", e.getMessage());
        // }

        // SessionInitializer.init("/be.ehealth.businessconnector.intrahub.test.properties");
        // ConfigFactory.getConfigValidator().setProperty("endpoint.hub.intra", url);
        // ConfigFactory.getConfigValidator().setProperty(HubConfig.HUB_ID, hubid);
        // ConfigFactory.getConfigValidator().setProperty(HubConfig.HUB_APP, appid);

        try {
            hubServiceComplete.putTransaction(transactionToPut);
            Assert.fail("expected KmehrBusinessConnectorException");
        } catch (KmehrBusinessConnectorException e) {
            Assert.assertTrue(e.getMessage().contains("Vitalink is now the place for sumehrs"));
        }

        TransactionIdType transid = new TransactionIdType();
        transid.getIds().add(HubTestHelper.createTransactionId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.UUID).generateId()));
        hubServiceComplete.revokeTransaction(HubTestHelper.createPatientIdType(), transid);

        // List<ErrorType> errors = putTransaction.getAcknowledge().getErrors();
        // Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());

        therapeuticLink.setEnddate(new DateTime());
        hubServiceComplete.revokeTherapeuticLink(therapeuticLink);

        consent.setRevokedate(new DateTime());
        hubServiceComplete.revokePatientConsent(consent);
    }
}
