/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.session;

import java.util.List;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.hubservices.core.v1.Consent;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.GetPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.PutPatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokePatientConsentResponse;
import be.fgov.ehealth.hubservices.core.v1.SelectGetPatientConsentType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENT;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTvalues;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;


/**
 * Test on the consent operations
 * 
 * @author EHP
 */
public class ConsentIntegrationTest extends AbstractIntrahubIntegrationTest {

    /**
     * PutPatientConsent Test
     */
    @Test
    public void putPatientConsent() throws Exception {
        ConsentType consent = HubTestHelper.createConsentType();
        PutPatientConsentResponse putPatientConsent = hubServiceComplete.putPatientConsent(consent);

        consent.setRevokedate(new DateTime());
        hubServiceComplete.revokePatientConsent(consent);

        List<ErrorType> errors = putPatientConsent.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * GetPatientConsent Test
     */
    @Test
    public void getPatientConsent() throws ConnectorException, TechnicalConnectorException, IntraHubBusinessConnectorException {
        ConsentType consent = HubTestHelper.createConsentType();
        hubServiceComplete.putPatientConsent(consent);

        GetPatientConsentResponse patientConsent = hubServiceComplete.getPatientConsent(createSelectGetPatientConsentType());

        consent.setRevokedate(new DateTime());
        hubServiceComplete.revokePatientConsent(consent);

        List<ErrorType> errors = patientConsent.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * RevokePatientConsent Test
     */
    @Test
    public void revokePatientConsent() throws Exception {
        ConsentType consent = HubTestHelper.createConsentType();
        hubServiceComplete.putPatientConsent(consent);

        consent.setRevokedate(new DateTime());
        RevokePatientConsentResponse revokePatientConsent = hubServiceComplete.revokePatientConsent(consent);

        List<ErrorType> errors = revokePatientConsent.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }

    /**
     * Create a selectGetPatientConsentType used for consent operations
     */
    private SelectGetPatientConsentType createSelectGetPatientConsentType() {
        SelectGetPatientConsentType patientConsent = new SelectGetPatientConsentType();

        Consent selectConsent = new Consent();
        CDCONSENT cdConsent = new CDCONSENT();
        cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
        cdConsent.setSV("1.0");
        cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
        selectConsent.getCds().add(cdConsent);
        patientConsent.setConsent(selectConsent);

        patientConsent.setPatient(HubTestHelper.createPatientIdType());
        return patientConsent;
    }

}
