/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

class OCSPURLReader {
    private static final Logger LOGGER = Logger.getLogger(OCSPURLReader.class);
    private String ocspURL;

    public OCSPURLReader() {
        this(null);
    }

    public OCSPURLReader(String ocspURL) {
        this.ocspURL = ocspURL;
    }

    public URI getOcspServiceLocation(X509Certificate x509cert) throws OCSPException {
        if (this.ocspURL != null && !this.ocspURL.isEmpty()) {
            LOGGER.info((Object)("Using given OCSP URL: " + this.ocspURL));
            return this.buildOcspUri(this.ocspURL);
        }
        LOGGER.debug((Object)"Retrieving OCSP URL from X.509 Certificate");
        AuthorityInformationAccess authorityInfoAccess = this.buildAuthorityInfoAccess(x509cert);
        for (AccessDescription accessDescription : authorityInfoAccess.getAccessDescriptions()) {
            String accessUri = DERIA5String.getInstance((Object)accessDescription.getAccessLocation().getName()).getString();
            LOGGER.debug((Object)("AccessDescription [ID= " + accessDescription.getAccessMethod().getId() + ", URI=" + accessUri + "]"));
            if (!accessDescription.getAccessMethod().equals((Object)OCSPObjectIdentifiers.id_pkix_ocsp)) continue;
            return this.buildOcspUri(accessUri);
        }
        throw new OCSPException("No OCSP Service location was found in the certificate.");
    }

    private AuthorityInformationAccess buildAuthorityInfoAccess(X509Certificate x509cert) throws OCSPException {
        byte[] authorityInfoAccessBytes = x509cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (authorityInfoAccessBytes == null) {
            throw new OCSPException("No OCSP Service location was found in the certificate.");
        }
        AuthorityInformationAccess authorityInfoAccess = null;
        try {
            authorityInfoAccess = AuthorityInformationAccess.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])authorityInfoAccessBytes));
        }
        catch (IOException e) {
            throw new OCSPException("Failed to retrieve the AuthorityInformationAccess Extension (containing the location of the OCSP service) from the certificate.", e);
        }
        return authorityInfoAccess;
    }

    private URI buildOcspUri(String accessUri) throws OCSPException {
        try {
            return new URI(accessUri);
        }
        catch (URISyntaxException e) {
            throw new OCSPException("OCSP Service URI is not correctly formatted.", e);
        }
    }
}

