/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.etee.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.etee.impl.AbstractRevocationStatusChecker;
import be.fgov.ehealth.etee.crypto.cert.CertificateStatus;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.ocsp.RevocationValues;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorOCSPRevocationStatusChecker
extends AbstractRevocationStatusChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorOCSPRevocationStatusChecker.class);
    private OCSPChecker ocspchecker;

    public ConnectorOCSPRevocationStatusChecker() {
        HashMap<OCSPOption, Object> options = new HashMap<OCSPOption, Object>();
        try {
            options.putAll(CryptoFactory.getOCSPOptions());
        }
        catch (TechnicalConnectorException e) {
            LOG.warn("Unable to load ocsp options.", (Throwable)e);
        }
        this.ocspchecker = OCSPCheckerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.RECEIVER_MANDATORY, options).build();
    }

    @Override
    boolean delegateRevoke(X509Certificate cert, DateTime validOn) throws CertificateException {
        CryptoResult result = this.ocspchecker.validate(cert, validOn.toDate(), new RevocationValues());
        if (result.getFatal() != null || result.getData() == null) {
            throw new CertificateException(result.toString());
        }
        return !((OCSPData)result.getData()).getCertStatus().equals((Object)CertificateStatus.VALID);
    }
}

