/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.mycarenetcommons.builders.CommonBuilder;
import be.ehealth.business.mycarenetcommons.builders.util.PropertyUtil;
import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.Identification;
import be.ehealth.business.mycarenetcommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Origin;
import be.ehealth.business.mycarenetcommons.domain.Party;
import be.ehealth.business.mycarenetcommons.domain.Routing;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.util.Map;
import org.joda.time.DateTime;

public abstract class AbstractCommonBuilderImpl
implements CommonBuilder {
    private static final String SENDER_PROPERTIES_ARE_NOT_COHERENT = " Sender properties are not coherent";
    protected static final String NIHII = ".nihii";
    protected static final String CBE = ".cbe";
    protected static final String NAME = ".name";
    protected static final String SSIN = ".ssin";
    protected static final String ORGANIZATION = ".organization";
    private static final String SENDER = ".sender";
    private static final String SITE_ID = ".site.id";
    protected static final String MYCARENET = "mycarenet.";
    private static final String QUALITY = ".quality";
    private static final String PHYSICALPERSON = ".physicalperson";
    private static final String VALUE = ".value";
    protected String projectName = "default";
    private ConfigValidator config = ConfigFactory.getConfigValidator();

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        if (parameterMap == null || parameterMap.isEmpty() || !parameterMap.containsKey("projectName")) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, new Object[]{"missing config parameters for initialize of CommonBuilder , check factory method call"});
        }
        this.projectName = (String)parameterMap.get("projectName");
    }

    @Override
    @Deprecated
    public CommonInput createCommonInput(PackageInfo packageInfo, boolean isTest, String inputReference) throws TechnicalConnectorException {
        Origin origin = this.createOrigin(packageInfo);
        return new CommonInput(isTest, origin, inputReference);
    }

    @Override
    public CommonInput createCommonInput(McnPackageInfo packageInfo, boolean isTest, String inputReference) throws TechnicalConnectorException {
        Origin origin = this.createOrigin(packageInfo);
        return new CommonInput(isTest, origin, inputReference);
    }

    @Override
    @Deprecated
    public Origin createOrigin(PackageInfo packageInfo) throws TechnicalConnectorException {
        Origin origin = new Origin(packageInfo, this.createCareProviderForOrigin());
        origin.setSender(this.createSenderForOrigin());
        origin.setSiteId(this.getSiteId());
        return origin;
    }

    @Override
    public Origin createOrigin(McnPackageInfo packageInfo) throws TechnicalConnectorException {
        Origin origin = new Origin(packageInfo, this.createCareProviderForOrigin());
        origin.setSender(this.createSenderForOrigin());
        origin.setSiteId(this.getSiteId());
        return origin;
    }

    private String getSiteId() throws TechnicalConnectorException {
        if (this.projectName == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[]{"projectName"});
        }
        String projectNameToUse = PropertyUtil.retrieveProjectNameToUse(this.projectName, MYCARENET);
        String siteIdKey = MYCARENET + projectNameToUse + SITE_ID;
        String siteId = this.config.getProperty(siteIdKey);
        return siteId;
    }

    Party createSenderForOrigin() throws TechnicalConnectorException {
        Party party = new Party();
        String senderRootKey = MYCARENET + PropertyUtil.retrieveProjectNameToUse(this.projectName, "mycarenet..") + SENDER;
        party.setPhysicalPerson(this.createPerson(senderRootKey + PHYSICALPERSON));
        party.setOrganization(this.createOrganization(senderRootKey + ORGANIZATION));
        return party;
    }

    @Override
    public Routing createRouting(Patient patientInfo, DateTime refDate) {
        Routing routing = new Routing();
        routing.setPeriod(null);
        routing.setCareReceiver(this.createCareReceiver(patientInfo));
        routing.setReferenceDate(refDate);
        return routing;
    }

    @Override
    public Routing createRoutingToMutuality(String mutuality, DateTime refDate) {
        Routing routing = new Routing();
        routing.setPeriod(null);
        routing.setCareReceiver(this.createCareReceiverForMutuality(mutuality));
        routing.setReferenceDate(refDate);
        return routing;
    }

    protected final CareReceiverId createCareReceiver(Patient patientInfo) {
        CareReceiverId careReceiver = new CareReceiverId(patientInfo.getInss(), patientInfo.getRegNrWithMut(), patientInfo.getMutuality());
        return careReceiver;
    }

    protected final CareReceiverId createCareReceiverForMutuality(String mutuality) {
        CareReceiverId careReceiver = new CareReceiverId(null, null, mutuality);
        return careReceiver;
    }

    protected Identification createOrganization(String key) throws TechnicalConnectorException {
        boolean containsOrganization;
        Identification identification = this.getIdentification(key);
        boolean bl = containsOrganization = identification != null;
        if (containsOrganization && identification.getCbe() == null && identification.getNihii() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, new Object[]{"Organization Sender properties are not coherent"});
        }
        return identification;
    }

    protected Identification createPerson(String key) throws TechnicalConnectorException {
        boolean containsPhysicalPerson;
        Identification identification = this.getIdentification(key);
        boolean bl = containsPhysicalPerson = identification != null;
        if (containsPhysicalPerson && identification.getSsin() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, new Object[]{"Physical person Sender properties are not coherent"});
        }
        return identification;
    }

    private Identification getIdentification(String key) {
        String cbe;
        String nihii;
        String ssin;
        Identification identification = new Identification();
        String name = this.config.getProperty(key + NAME);
        if (name != null) {
            identification.setName(name);
        }
        if ((ssin = this.config.getProperty(key + SSIN)) != null) {
            identification.setSsin(ssin);
        }
        if ((nihii = this.config.getProperty(key + NIHII + VALUE)) != null) {
            String quality = this.config.getProperty(key + NIHII + QUALITY);
            Nihii nihiiObject = new Nihii(quality, nihii);
            identification.setNihii(nihiiObject);
        }
        if ((cbe = this.config.getProperty(key + CBE)) != null) {
            identification.setCbe(cbe);
        }
        if (this.isIdentificationEmpty(identification)) {
            return null;
        }
        return identification;
    }

    private boolean isIdentificationEmpty(Identification identification) {
        return identification.getCbe() == null && identification.getName() == null && identification.getNihii() == null && identification.getSsin() == null;
    }

    protected abstract CareProvider createCareProviderForOrigin() throws NumberFormatException, TechnicalConnectorException;
}

