/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import java.security.PrivateKey;

public final class EncryptionCredential {
    private final PrivateKey privateKey;
    private final String encryptionTokenSerialNumber;

    private EncryptionCredential(PrivateKey privateKey, String encryptionTokenSerialNumber) {
        this.privateKey = privateKey;
        this.encryptionTokenSerialNumber = encryptionTokenSerialNumber;
    }

    public static EncryptionCredential create(PrivateKey privateKey, String encryptionTokenSerialNumber) {
        EncryptionCredential.validateInput(privateKey, encryptionTokenSerialNumber);
        return new EncryptionCredential(privateKey, encryptionTokenSerialNumber);
    }

    private static void validateInput(PrivateKey privateKey, String encryptionTokenSerialNumber) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The given private key cannot be null");
        }
        if (encryptionTokenSerialNumber == null || encryptionTokenSerialNumber.isEmpty()) {
            throw new IllegalArgumentException("The given encryptionTokenSerialNumber cannot be null or empty");
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getEncryptionTokenSerialNumber() {
        return this.encryptionTokenSerialNumber;
    }
}

