﻿/*
 * Copyright (c) eHealth
 */

using System;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using be.fgov.ehealth.dics.protocol.v2;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.joda.time;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

/**
 * Integration tests for tarification.
 * 
 * @author eHealth Platform
 * 
 */
namespace be.ehealth.businessconnector.dicsv2.session
{
public class DicsIntegrationTest {

    [SetUpAttribute]
    public static void setupsession() {
    	SessionInitializer.init(".\\be.ehealth.businessconnector.dicsv2.test.properties",true, SupportedLanguages.NET.getAbbreviation());
    }

    [TearDownAttribute]
    public static void teardownSession() {
        Session.getInstance().unloadSession();
    }

    [Test]
    public void findAmpTest() {
        FindAmpRequest findAmpRequest = new FindAmpRequest();
        findAmpRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findAmpRequest.setIssueInstant(new org.joda.time.DateTime());
        findAmpRequest.setLang("fr");
        
        FindByActualProductType product = new FindByActualProductType();
        product.setAmpCode("SAM276385-00");
        findAmpRequest.setFindByProduct(product);

        FindAmpResponse response = DicsSessionServiceFactory.getDicsSession().findAmp(findAmpRequest);

        Assert.NotNull(response.getAmps());
        Assert.AreNotEqual(0, response.getAmps().size());
    }

    [Test]
    public void findCompanyTest() {
        FindCompanyRequest findCompanyRequest = new FindCompanyRequest();
        findCompanyRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findCompanyRequest.setIssueInstant(new org.joda.time.DateTime());
        findCompanyRequest.setLang("fr");
        
        findCompanyRequest.setCompanyActorNr("05006");

        FindCompanyResponse response = DicsSessionServiceFactory.getDicsSession().findCompany(findCompanyRequest);

        Assert.NotNull(response.getCompanies());
        Assert.AreNotEqual(0, response.getCompanies().size());
    }
    
    [Test]
    public void findLegislationTextTest() {
        FindLegislationTextRequest findLegTextRequest = new FindLegislationTextRequest();
        findLegTextRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findLegTextRequest.setIssueInstant(new org.joda.time.DateTime());
        findLegTextRequest.setLang("fr");
        
        findLegTextRequest.setFindLegalBases(new FindLegalBasesType());

        FindLegislationTextResponse response = DicsSessionServiceFactory.getDicsSession().findLegislationText(findLegTextRequest);

        Assert.NotNull(response.getStatus());
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
    }
    
    [Test]
    public void findReferencesTest() {
        FindReferencesRequest findRefRequest = new FindReferencesRequest();
        findRefRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findRefRequest.setIssueInstant(new org.joda.time.DateTime());
        
        findRefRequest.setReferenceEntity("Wada");

        FindReferencesResponse response = DicsSessionServiceFactory.getDicsSession().findReferences(findRefRequest);

        Assert.NotNull(response.getWadas());
        Assert.AreNotEqual(0, response.getWadas().size());
    }
    
    [Test]
    public void findReimboursementTest() {
        FindReimbursementRequest findReimboursementRequest = new FindReimbursementRequest();
        findReimboursementRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findReimboursementRequest.setIssueInstant(new org.joda.time.DateTime());
        findReimboursementRequest.setLang("fr");
        
        FindByPackageType packageType = new FindByPackageType();
        packageType.setCtiExtendedCode("444053-03");
        findReimboursementRequest.setFindByPackage(packageType );

        FindReimbursementResponse response = DicsSessionServiceFactory.getDicsSession().findReimbursement(findReimboursementRequest);

       Assert.NotNull(response.getStatus());
        Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
    }
    
    [Test]
    public void findVmpTest() {
        FindVmpRequest findVmpRequest = new FindVmpRequest();
        findVmpRequest.setId(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId());
        findVmpRequest.setIssueInstant(new org.joda.time.DateTime());
        findVmpRequest.setLang("fr");
        

        FindByTherapeuticMoietyType therapeuticMoiety = new FindByTherapeuticMoietyType();
        therapeuticMoiety.setTherapeuticMoietyCode(new java.math.BigInteger("10"));
        findVmpRequest.setFindByTherapeuticMoiety(therapeuticMoiety );

        FindVmpResponse response = DicsSessionServiceFactory.getDicsSession().findVmp(findVmpRequest);

        Assert.NotNull(response.getVmps());
        Assert.AreNotEqual(0, response.getVmps().size());
    }
}
}