/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import org.junit.Test;

import be.ehealth.technicalconnector.config.Configuration;


/**
 * Unit test for SSL Configuration module
 * 
 * @author EHP
 *  
 */
public class ConfigurationModuleSSLTest {

    /**
     * Creates a mock for the Configuration class with default values : keystore_dir = /P12/ truststore_location = trustStore.jks
     * connector.configurationmodule.ssl.debug = false
     * 
     * Calls the init() method of this mock
     * 
     * @author EHP
     */
    @Test
    public void testKeyStoreOnClassPath() throws Exception {

        Configuration configuration = new InMemoryConfigurationMock();
        configuration.setProperty("KEYSTORE_DIR", "/P12/int/");
        configuration.setProperty("truststore_location", "trustStore.jks");
        configuration.setProperty("truststore_password", "changeit");
        configuration.setProperty("connector.configurationmodule.ssl.debug", "true");

        ConfigurationModuleSSL module = new ConfigurationModuleSSL();
        module.init(configuration);


    }


}
