/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl.xades.domain;

import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.CertRef;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.CrlRef;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.OcspRef;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.etsi.uri._01903.v1_3.CRLRefsType;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.CompleteCertificateRefsType;
import org.etsi.uri._01903.v1_3.CompleteRevocationRefsType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIData;
import org.etsi.uri._01903.v1_3.OCSPRefsType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_3.SigningCertificate;
import org.etsi.uri._01903.v1_3.UnsignedProperties;
import org.etsi.uri._01903.v1_3.UnsignedSignatureProperties;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.w3._2000._09.xmldsig.CanonicalizationMethod;
import org.w3c.dom.Document;

public class UnsignedPropertiesBuilder {
    private static MarshallerHelper<UnsignedProperties, UnsignedProperties> marshaller = new MarshallerHelper(UnsignedProperties.class, UnsignedProperties.class);
    private String id;
    private List<XAdESTimeStampType> signatureTimestamps = new ArrayList<XAdESTimeStampType>();
    private List<CertRef> completeCertRefs = new ArrayList<CertRef>();
    private List<CrlRef> crlRefs = new ArrayList<CrlRef>();
    private List<OcspRef> ocspRefs = new ArrayList<OcspRef>();

    public String getId() {
        return "xmldsig-" + this.id + "-xades-unsignedprops";
    }

    private String getTimestampId() {
        return "time-stamp-" + this.id;
    }

    private String getEncapsulatedTimeStampID() {
        return "time-stamp-token-" + this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addSignatureTimestamp(byte[] tsToken, String c14nMethod) {
        XAdESTimeStampType timestamp = new XAdESTimeStampType();
        CanonicalizationMethod method = new CanonicalizationMethod();
        method.setAlgorithm(c14nMethod);
        timestamp.setCanonicalizationMethod(method);
        EncapsulatedPKIData encapsulatedTS = new EncapsulatedPKIData();
        encapsulatedTS.setValue(tsToken);
        encapsulatedTS.setId(this.getEncapsulatedTimeStampID());
        timestamp.getEncapsulatedTimeStampsAndXMLTimeStamps().add(encapsulatedTS);
        timestamp.setId(this.getTimestampId());
        this.signatureTimestamps.add(timestamp);
    }

    public void addCertificate(X509Certificate cert) {
        this.completeCertRefs.add(new CertRef(cert));
    }

    public void addOCSPRef(byte[] oscpEncoded) {
        this.ocspRefs.add(new OcspRef(oscpEncoded));
    }

    public void addCrlRef(X509CRL crl) {
        this.crlRefs.add(new CrlRef(crl));
    }

    public UnsignedProperties build() {
        if (this.completeCertRefs.isEmpty() && this.signatureTimestamps.isEmpty() && this.crlRefs.isEmpty() && this.ocspRefs.isEmpty()) {
            return null;
        }
        UnsignedProperties unsignedProperties = new UnsignedProperties();
        unsignedProperties.setId(this.getId());
        UnsignedSignatureProperties unsignedSignatureProperties = new UnsignedSignatureProperties();
        unsignedSignatureProperties.getSignatureTimeStamps().addAll(this.signatureTimestamps);
        unsignedProperties.setUnsignedSignatureProperties(unsignedSignatureProperties);
        if (!this.completeCertRefs.isEmpty()) {
            SigningCertificate completeSigningCertRefs = new SigningCertificate();
            for (CertRef ref : this.completeCertRefs) {
                completeSigningCertRefs.getCerts().add(ref.convertToCertID());
            }
            unsignedSignatureProperties.setCompleteCertificateRefs(new CompleteCertificateRefsType());
            unsignedSignatureProperties.getCompleteCertificateRefs().setCertRefs(completeSigningCertRefs);
        }
        if (!this.crlRefs.isEmpty() || !this.ocspRefs.isEmpty()) {
            unsignedSignatureProperties.setCompleteRevocationRefs(new CompleteRevocationRefsType());
            unsignedSignatureProperties.setRevocationValues(new RevocationValuesType());
            if (!this.crlRefs.isEmpty()) {
                CRLRefsType crlRefType = new CRLRefsType();
                CRLValuesType crlValueType = new CRLValuesType();
                for (CrlRef crlRef : this.crlRefs) {
                    crlRefType.getCRLReves().add(crlRef.convertToXadesCRLRef());
                    crlValueType.getEncapsulatedCRLValues().add(crlRef.convertToXadesEncapsulatedPKIData());
                }
                unsignedSignatureProperties.getRevocationValues().setCRLValues(crlValueType);
                unsignedSignatureProperties.getCompleteRevocationRefs().setCRLRefs(crlRefType);
            }
            if (!this.ocspRefs.isEmpty()) {
                OCSPRefsType ocspRefsType = new OCSPRefsType();
                OCSPValuesType ocspValueType = new OCSPValuesType();
                for (OcspRef ocspRef : this.ocspRefs) {
                    ocspRefsType.getOCSPReves().add(ocspRef.convertToXadesOCSPRef());
                    ocspValueType.getEncapsulatedOCSPValues().add(ocspRef.convertToXadesEncapsulatedPKIData());
                }
                unsignedSignatureProperties.getRevocationValues().setOCSPValues(ocspValueType);
                unsignedSignatureProperties.getCompleteRevocationRefs().setOCSPRefs(ocspRefsType);
            }
        }
        return unsignedProperties;
    }

    public Document buildAsDocument() {
        UnsignedProperties unsignedProperties = this.build();
        if (unsignedProperties == null) {
            return null;
        }
        return marshaller.toDocument((Object)unsignedProperties);
    }
}

