/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.KeyStoreInfo;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.etee.crypto.utils.KeyManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreManager {
    private KeyStoreInfo keyStoreInfo;
    private KeyStore keyStore;
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreManager.class);

    @Deprecated
    public KeyStoreManager(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStoreManager(KeyStore keyStore, KeyStoreInfo keyStoreInfo) {
        this.keyStore = keyStore;
        this.keyStoreInfo = keyStoreInfo;
    }

    public KeyStoreManager(KeyStoreInfo keyStoreInfo) throws TechnicalConnectorException {
        this.keyStoreInfo = keyStoreInfo;
        this.keyStore = this.getKeyStore(keyStoreInfo.getKeystorePath(), keyStoreInfo.getKeystorePassword());
    }

    public KeyStoreManager(String pathKeystore, char[] keyStorePassword) throws TechnicalConnectorException {
        this.keyStore = this.getKeyStore(pathKeystore, keyStorePassword);
    }

    private KeyStore getKeyStore(String pathKeystore, char[] keyStorePassword) throws TechnicalConnectorException {
        try {
            if (pathKeystore != null) {
                String keystoreType = "PKCS12";
                if (pathKeystore.toLowerCase().contains(".jks")) {
                    keystoreType = "JKS";
                }
                try {
                    return KeyManager.getKeyStore((InputStream)ConnectorIOUtils.getResourceAsStream(pathKeystore), (String)keystoreType, (char[])keyStorePassword);
                }
                catch (KeyManager.KeyStoreOpeningException e) {
                    LOG.error("Trying to load keystore with ./");
                    return KeyManager.getKeyStore((InputStream)ConnectorIOUtils.getResourceAsStream("./" + pathKeystore), (String)keystoreType, (char[])keyStorePassword);
                }
            }
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_KEYSTORE_LOAD;
            LOG.debug(MessageFormat.format(errorValue.getMessage(), "<empty>"));
            throw new TechnicalConnectorException(errorValue, "<empty>");
        }
        catch (KeyManager.KeyStoreOpeningException e) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_KEYSTORE_PASSWORD;
            LOG.debug(MessageFormat.format(errorValue.getMessage(), pathKeystore));
            throw new TechnicalConnectorException(errorValue, (Throwable)e, pathKeystore);
        }
        catch (CertificateException e) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_KEYSTORE_LOAD;
            LOG.debug(MessageFormat.format(errorValue.getMessage(), pathKeystore));
            throw new TechnicalConnectorException(errorValue, (Throwable)e, pathKeystore);
        }
        catch (IOException e) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_KEYSTORE_LOAD;
            LOG.debug(MessageFormat.format(errorValue.getMessage(), pathKeystore));
            throw new TechnicalConnectorException(errorValue, (Throwable)e, pathKeystore);
        }
    }

    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    public final KeyStoreInfo getKeyStoreInfo() {
        return this.keyStoreInfo;
    }
}

