﻿using be.ehealth.technicalconnector.enumeration;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using ikvm.extensions;
using java.util;
using oasis.names.tc.dss._1_0.core.schema;
using org.w3._2000._09.xmldsig;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * Time Stamping Service Integration Tests This test shows the use of the Time Stamping Consult Service through the use of the Technical
 * Connector.
 *
 * All Tests require the following pre-requisites to be met:
 * <ul><li> An eHealth certificate with access to the Time Stamping service</li></ul>
 */
namespace be.ehealth.technicalconnector.service.timestamp
{
	using System;
	using System.Collections.Generic;
	using System.IO;
	using System.Linq;
	using System.Text;
	using System.Threading;

	using be.behealth.webservices.tsa;
	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.service.timestamp;
	using be.ehealth.technicalconnector.service.timestamp.impl;
	using be.ehealth.technicalconnector.utils;
	using be.ehealth.technicalconnector.utils.net;

	using NUnit.Framework;

	using org.bouncycastle.tsp;
	using org.bouncycastle.util.encoders;

	[TestFixture]
	class TimeStampingAuthorityIntegrationTest
	{
		#region Fields
		private static java.util.Properties config;

		#endregion Fields

		#region Methods

		[SetUpAttribute]
		public static void init()
		{
			config = TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",SupportedLanguages.NET.getAbbreviation());
			SessionInitializer.init(false);
		}
		/**
		 * Test the SingRequest opeation with a base64 document as input
		 * 
		 * @author EHP
		 */
		[Test]
		public void signRequestWithDocument() {


			string requestId = IdGeneratorFactory.getIdGenerator().generateId();
			string profile = "urn:ehealth:profiles:timestamping:1.1";

			// read out a sample file
			byte[] base64Document = Base64.encode("test".getBytes());

			SignRequest request = new SignRequest();
			request.setRequestID(requestId);
			request.setProfile(profile);

			InputDocuments inputDocuments = new InputDocuments();
			DocumentType document = new DocumentType();
			Base64Data inputDocument = new Base64Data();
			inputDocument.setMimeType(MimeType.plaintext.getValue());
			inputDocument.setValue(base64Document);
			document.setBase64Data(inputDocument);

			inputDocuments.getDocument().add(document);
			request.setInputDocuments(inputDocuments);

			invoke(request);
		}

		/**
		 * Test the SingRequest opeation with the hash of the document as input
		 * 
		 * @author EHP
		 */
		[Test]
		public void signRequestWithDocumentHash() {

			String requestId = IdGeneratorFactory.getIdGenerator().generateId();
			String profile = "urn:ehealth:profiles:timestamping:2.1";
			String hashAlgo = "SHA-256";
			String xmlEncAlgo ="http://www.w3.org/2001/04/xmlenc#sha256";

			// Calculate the hash of the sample file
			byte[] hash = ConnectorCryptoUtils.calculateDigest(hashAlgo,"test".getBytes());

			SignRequest request = new SignRequest();
			request.setRequestID(requestId);
			request.setProfile(profile);

			InputDocuments inputDocuments = new InputDocuments();
			DocumentHash document = new DocumentHash();
			DigestMethod method = new DigestMethod();
			method.setAlgorithm(xmlEncAlgo);
			document.setDigestMethod(method);
			document.setDigestValue(hash);

			inputDocuments.getDocumentHash().add(document);
			request.setInputDocuments(inputDocuments);

			invoke(request);

		}

		private static void invoke(SignRequest request) {
			/*
			 * Invoke the technical connector framework's Time Stamping Authority Service's SignRequest operation
			 */
			// get the X509 certificate and private key from the test keystore. (retrieved from property file)
			Credential credential = new KeyStoreCredential(config.getProperty("test.timestamping.location"), config.getProperty("test.timestamping.alias"), config.getProperty("test.timestamping.password"));

			// Timestamp the document
			SignResponse response = ServiceFactory.getAuthorityService().signRequest(credential.getCertificate(), credential.getPrivateKey(), request);

			/*
			 * Verify the response
			 */
			// check if response has been received
			Assert.IsNotNull(response);
			// check if the timestamping was a success
			Assert.AreEqual("urn:oasis:names:tc:dss:1.0:resultmajor:Success", response.getResult().getResultMajor());
		}
		#endregion Methods
	}
}