﻿#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
* ETK Service Integration Tests This test shows the use of the Key Depot Service through the use of the Technical Connector
*/
namespace be.ehealth.technicalconnector.service.sts
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    using be.ehealth.technicalconnector.beid;
    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.exception;
    using be.ehealth.technicalconnector.service.sts;
    using be.ehealth.technicalconnector.service.sts.domain;
    using be.ehealth.technicalconnector.service.sts.impl;
    using be.ehealth.technicalconnector.service.sts.security;
    using be.ehealth.technicalconnector.service.sts.security.impl;
    using be.ehealth.technicalconnector.utils;
    using be.ehealth.technicalconnector.utils.net;

    using NUnit.Framework;

    using org.w3c.dom;

    [TestFixture]
    class STSServiceUserIntegrationTest
    {
        #region Methods

        /**
         * Test the getToken operation from the Secured Token Service through the use of the Technical Connector.
         * This retrieves an SAML Assertion/Secure Token from the eHealth STS Service
         *
         * The getToken methods needs the following parameters:
         * - authentication credentials: the credentials used to authenticate against STS, usually your eID
         * - service credentials: the credentials used to sign each succeeding request to an STS secured eHealth web service, usually an eHealth issued certificate
         * - attributes needed for the STS assertion
         * - designators that STS needs to fill in
         * - validity of the session in hours
        */
        [Test]
        public void testGetToken()
        {
            /*
             * Set the values to use in this test
            */
            Element assertion = null;

            // get the Authentication Credential:  X509 certificate and private key. usually your eID (retrieved from property file)
            Credential authentication = new KeyStoreCredential(TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.location"),
                                                               TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.alias"),
                                                               TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.password"));
            // get the Service Credential:  X509 certificate and private key. usually an eHealth certificate (retrieved from property file)
            Credential service = new KeyStoreCredential(TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.location"),
                                                        TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.alias"),
                                                        TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.keystore.password"));

            // create the list of SAML Attributes
            java.util.List attributes = new java.util.ArrayList();

            //this is an example list of attributes, this must be adjusted based on the needs of the target application
            attributes.add(new SAMLAttribute("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace", TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.INSS")));
            attributes.add(new SAMLAttribute("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin","urn:be:fgov:identification-namespace",TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.INSS")));

            // create the list of SAML Attributes Designators
            java.util.List designators = new java.util.ArrayList();

            //this is an example list of attribute designators, this must be adjusted based on the needs of the target application
            designators.add(new SAMLAttributeDesignator("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin", "urn:be:fgov:identification-namespace"));
            designators.add(new SAMLAttributeDesignator("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace"));

            //validity of the session in hours
            int validity = 24;

            /*
             * Execute the request
             */

            STSService sts = ServiceFactory.getStsService();
            assertion = sts.getToken(authentication, service, attributes, designators, AbstractSTSService.HOK_METHOD, validity);

            Assert.IsNotNull(assertion);
            Console.WriteLine(assertion);
        }

        /**
         * Test the getToken operation from the Secured Token Service through the use of the Technical Connector.
         * This retrieves an SAML Assertion/Secure Token from the eHealth STS Service
         *
         * This example uses the eID reader to demonstrate the STS service in combination with an eID.
         *
         * The getToken methods needs the following parameters:
         * - authentication credentials: the credentials used to authenticate against STS, usually your eID
         * - service credentials: the credentials used to sign each succeeding request to an STS secured eHealth web service, usually an eHealth issued certificate
         * - attributes needed for the STS assertion
         * - designators that STS needs to fill in
         * - validity of the session in hours
         *
         * @throws TechnicalConnectorException
         *             the technical connector exception
         */
        [Test]
        public void testGetTokenWithEid()
        {
            /*
             * Set the values to use in this test
             */
            // Get the Authentication Credential:  X509 certificate and private key. usually your eID.
            // The Technical Connector provides build-in eID functionality.
            // This is done by simply calling EIDReader.getInstance().
            Credential authentication =     BeIDCredential.getInstance("session",BeIDCredential.EID_AUTH_ALIAS);
            // get the Service Credential:  X509 certificate and private key. usually an eHealth certificate (retrieved from property file)
            Credential service = BeIDCredential.getInstance("hok",BeIDCredential.EID_SIGN_ALIAS);

             // create the list of SAML Attributes
            java.util.List attributes = new java.util.ArrayList();

            //this is an example list of attributes, this must be adjusted based on the needs of the target application
            attributes.add(new SAMLAttribute("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace",BeIDInfo.getInstance().getIdentity().getNationalNumber()));
            attributes.add(new SAMLAttribute("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin", "urn:be:fgov:identification-namespace",BeIDInfo.getInstance().getIdentity().getNationalNumber()));

            // create the list of SAML Attributes Designators
            java.util.List designators = new java.util.ArrayList();

            //this is an example list of attribute designators, this must be adjusted based on the needs of the target .
            designators.add(new SAMLAttributeDesignator("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace"));
            designators.add(new SAMLAttributeDesignator("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin", "urn:be:fgov:identification-namespace"));

            //validity of the session in hours
            int validity = 24;

            /*
             * Invoke the technical connector framework's STS Service's getToken operation
             */
            STSService sts = ServiceFactory.getStsService();
            Element assertion = sts.getToken(authentication, service, attributes, designators, AbstractSTSService.HOK_METHOD, validity);

            /*
             * Verify the response
             */
            // check if the returned assertion is available
            Assert.IsNotNull(assertion);
        }

        #endregion Methods
    }
}