/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;

import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;


/**
 * @author EH053
 */
public class ConnectorCryptoUtilsTest {

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    @BeforeClass
    public static void init() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void decryptRSA_ECB_PKCS1Padding() throws Exception {
        byte[] encryptedBytes = Base64
            .decode("DhARN8TArXF4M0PHwKnXk79wrGW0zrFhlYELU3U6GLx4ZZQng2WHMWKzlP2LM/o0e1Xkwz2ZyD2j2jxYOUmo35qprduqNa7OLa5nwzwnhToTqiIk3YSUNPT+JqHiUkxyfqDXc7Zfmnx9od9ZSptEIG3spK4enc0rCRBb8QxwSPIHR4DS0hzje4vd+9uIumCucE8VWx1ouex2oexDVBwwF8RDiymgXFyFJMT2eA1S3Ii2ObJX0tdAqjrlMmUjc8WFsp5yuDlbpzJ3QH4ZP+CcptUEOkbxId2ru5fur+DveUVb9Z388B/F9VtCY12frHGV/KOU1j8g9TcpwpD3XvoxnYWcumK6NGvl8IMPC65rd3vgUYhXyobp9IE+1i9CxtTTGtSZfFGjVvxGmaQQ83gFEFy7OkPt1lpHsqLP5D2oiFOGTZL5Ne1tI9OPeaGYfAwmkf6Lm52WnuvPdlYVAN2ps44AyvxlMnzeV00OCWB/NTtonp8ZF9uVF4HaHzGD1T8jfSGvbTDyvBESDFRHxkLWW/QK+a2aFrEtTyG6kmyoy8RzfKZxrwnsODvz5Y/GMArwteei/kVW81jJj0lJZIKaGVh3uwVhmHDCPQ8/gs84Q6y3h/8fkTSKNYGadQagKM9JPqH69+yZxxqK92cl1A3SHRsUOmyh9qhXipVXQ1GcnrSGtUcyVT4+Ppy3hTkymlmULd0GGIlxBRqU9sofoVwPu8HSBNFszo42w2y/VMLTK32brhbCBJTm0YWi94+P80sWXs2/KTSdHMGfTIeSoI/DasJ9aNvdUNqseYQUqxUMFdnemv2txRIDQBLV4qZ+X1YqHIEuUgsaTOKuEuZZxUGyW3d77ZSwATvyYWn3iWyi6fUZ8Y31oEk4wbnmID2q8rzvYqOm58l2W8ErK0aywQprP049jccXHy2wvXLTLAjo4qTT1/gQ70dOmYh+sT5zFt4eEhQ66nL0XSMR5oMPxxSoGeuQFcJyn96so5nQVWeKtwx889E30Evh2zYSxfxGWGOnk9VlH92VdRQ74Qh/8apsan7/V2qg7hBqSOSJojAcxPlSe4VRv5Im0vxp3AkES3kh7cKeCVG6+v09xqwuz9IFi2lokeAsmYH6jrzfhuwAgXAcKrXwg40Gwfw5YUdMMyiFqkQlqPv+2PkINpTHKE4TZ9Snwq3znU37ZqDT+9ny0lTGlMtiIKKAiSJClz4Hlb4h9mbBWaUIv/bY1jjOlJJU/W4hV0gh4xWc8WWY2J3z1SSSuB1HxZ2IU+k/O/jNguYSMscmaFvP4fqnjignrRApDQafwIi8khlI0HesKYSqnOUC2iY8bqiNuybQo0yv+ZichFmOKK8m4wTy4w9jxc5SOw=="
                .getBytes());
        byte[] encryptKey = Base64
            .decode("MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCVvPEdHCIFGVGZukRXHwZoQKeZbRjLdQtbCQQog7eFke2coyPVWh1CT3Nnl3SOisQKltaQ3nGT2cM+cMFjh++5kI+Bjh5UaI3vFMS0bKeFnOqK+jfdGe7HWkuhgd1HuCDsthl0yaxvLSkq05fCgph16R4TcdxZz8VDEFxuk9mGQwrM8ZtrxJZMkUkbu3yTGm0aidRq9JwzOOxFKbQecAMbrPuRY38h9EVb9SflorPRT0QASsQ6nB65aSK5N/wzA9T7pORirOgo5WJghOcPTARW26V5A7G3ppRk7sIllbpL7d15cwpr878kphkPJBD0Loel7Nf8B0EfXdGkVxQJa1VxAgMBAAECggEAGgaoJfYg16AJ9d1RSY9D7tTmDJ3QxHRIj/8mMOCMAnRVx3b3oHq0QTVMCsJhaPEnl+uVycJQHXGpJO42PtV+zlMZDlykWul9WgPTGMUV7PxUK+nH0e9S+GVyZdULoA6Z8mrIS+tNxFkmIaJ7azyFwWDOcHTG5vldAQYT+shJ87LpCv6XjQD36Bj7+UKbXGgez0uXzal4dXLxkg5mZ7CCPwbC81hal0TUkBLU234BqJUkGZ9XF25rLqg/pNA2AW6HiV1xV9nssQmkXEyN8VETa+MFOxvzdvPpxS4wmLys7YKkiBriHp6Gti/Y5rI5ny0iaEtN1MPjGIPLyLdp0BT2wQKBgQDXeug7CF7gZ3xV8AOrnRYT+c1gYRFTWfQJ7loXtgxUkTyMnyGBFyZTv006ybK9S1RhLNtxPUYQarGaoVIo/DVCl97Miv+Tahwt/dZzx69CI0f+J2ZlH4G7pj6qV0O3hCnqpYVm8EhONeFoXjLocu8iUmg+fKBEaAMLVAd85HjFaQKBgQCx5T+vAtC7sQ6n1TP4coLwTONl9tim1hdaAzVzxeH2yEPBfZEI0M/4YPTbGaupVbXruxu0jclsSqOz8EHQkfiwSEnotUk4XJFNmj0hrhICv083zOyvwFGZL8b/tzBI/AygzciYurHFdqIC0i2VVjz0nC65XTQQgbY8lQ3Xp9zmyQKBgBr0TvSDeYrMpysA2RSwk8Bv8RbrTYWFrRdI75Ajv6scd9yHU2OYh7zWI00FSgyPzcBSIikqJweKsSjMoUBrPCZWZRJlGM9R6LCAHkFhazT0wN60AwUHSe01QIWCYQAl0jB+AA/+Yq0V5Fpv3iJhrjQ25r9aS5oDAM579mvTEKBxAoGATgHa9SFk6ojvhkUFbxK3vCvbI2ElC7OhtcTmcYf6WD7lBznKmXUHXUEW3eTZ031UMrRvp7Ls+mGYe1UFZzI7PQHV9wdXvjFJPiA+YkB0gWPmlu9zcnYA0g2TU5q+v6JW30Sdi+uB/LbSwC3t8yhHvnOmQX5PUFWw1cv+r+xZ/5ECgYEAgQ7/wHePv98zlRfzEs5ytMjLxKL8SDgJWTDUoaYZT4qEV5hhUsBcUcaIXr+hEgHPLinlyI1CfBoj7tgGdm5jTweRarVdqJmjeRSPeAEnozqRYHK7iqFxUexUkNaJBeYW5/Jf3DjWWoIwa6lISb0IOlB2vx6iBL7byyUGXynXF88="
                .getBytes());
        byte[] expected = Base64
            .decode("6raWB1H6Hnyd+9aajBJKPjCCA5EwggJ5oAMCAQICEQDONh3oCZk9DnF7wrg5GCtUMA0GCSqGSIb3DQEBBQUAMF0xDjAMBgNVBAMTBWVIIENBMSEwHwYDVQQLExhlSGVhbHRoLXBsYXRmb3JtIEJlbGdpdW0xGzAZBgNVBAoTEkZlZGVyYWwgR292ZXJubWVudDELMAkGA1UEBhMCQkUwHhcNMDgxMDA4MTU0MjIzWhcNMjMxMDA4MTU0MjIzWjBeMQ8wDQYDVQQDEwZFVEstUkExITAfBgNVBAsTGGVIZWFsdGgtcGxhdGZvcm0gQmVsZ2l1bTEbMBkGA1UEChMSRmVkZXJhbCBHb3Zlcm5tZW50MQswCQYDVQQGEwJCRTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJqcHDgfz4swAuI5z3ZnGicnRunl+Zo+MfRF0tafmlpDlxHt8wRb7Tq1r5tOjQe0B5H5A1ENQ3OzwnZvuHOoViXQC3WNQqZja6prh2bUHrpirU9Ttf69zyCOUJiUTxAg8fWQBghVYg3IwSVtm7oqyCFhnFLmgGCrcarTZsjSDEuXjRvQLmxWCtpSy34bd4QDZcZvqD8dqXXi2zxclEA8TeaJwiV/qfb9cFniX4hiO3p85EHkxyq1d94YhlDfuNj+pz4mcVexbi1B+Sm1lDtivK+1vQ1XKwlgwYC01MWs8ePjO3OfHPN29Xpxv1iunR8Xi/E2QcIInihFLouguPfrXWcCAwEAAaNLMEkwNwYDVR0fBDAwLjAsoCqgKIYmLi9zcmMvdGVzdC9yZXNvdXJjZXMvbG9jYWxfZWhlYWx0aC5jcmwwDgYDVR0PAQH/BAQDAgeAMA0GCSqGSIb3DQEBBQUAA4IBAQCHCFXjgXtixQd47GuyVfKoZKP5gsS2EUd8i2rPBIzUftkqRbtfKy8rsicenBTlOIoCy6OgnyGuaej8vOcUEF6PQICtNm7ZNhdvytaXVuC6lsshEvzhENACFjXNHT8y/95E+rq/AGK/c1Xi+H2nUCDGPLERaSrlWK4aB12u0aTWM7hbF3+vAM5pAYkqH+Z/BjsOr7M8ibSxSsb6GmoHzbsQVbgIlN+Rnd4TKkRcZHlLKZcX+SxLE8MNPa2TCriC66aTiHv1P1Rf/eB5Np7yiliG5843LqTMdOW+h+mATJ6vYEbAuSq+DRwQxrL/ocbsDsF4VARCsdD83VpuI4KyUC+I"
                .getBytes());
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encryptKey);
        KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
        PrivateKey key = kf.generatePrivate(privateKeySpec);
        Assert.assertArrayEquals(expected, ConnectorCryptoUtils.decrypt(key, "RSA/ECB/PKCS1Padding", encryptedBytes));
    }

    @Test
    public void decryptDESede_ECB_PKCS5Padding() throws Exception {
        byte[] encryptedBytes = Base64.decode("cURk0dxjZxxl5gq07elvDL6VVrMRk8u9TnoqpEMbWCkRoL2h8nMoEnjW3gv1YF/EIJPF0RLcY67QBGqNX5rk/L0wBpcuksfOiV8B/EnZkPDqDBC3pOhqB2JD958uQuiNHL60+J4rI9dNvOYfJDVlOf+edGVSZ2z4c3xvyJs9JdJeQh7vWyDCxY3XI8WSWcC0btuhUqwIq9P55MhPHLsfmecKQU/As7X+rKKxASXqw2NkEZYSlq2fvfiMUSBOczr8g7azQ8ZUiEM=".getBytes());
        byte[] encryptKey = Base64.decode("fCDf1iz+bbOKmxpRtozlnnwg39Ys/m2z".getBytes());
        byte[] expected = Base64.decode("PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI/Pgo8bnMyOmNyZWF0ZVByZXNjcmlwdGlvblJlc3VsdCB4bWxuczpuczI9Imh0dHA6L3NlcnZpY2VzLnJlY2lwZS5iZS9wcmVzY3JpYmVyIj4KICAgIDxyaWQ+QkVQMDNLNDVWOFdZPC9yaWQ+CjwvbnMyOmNyZWF0ZVByZXNjcmlwdGlvblJlc3VsdD4K".getBytes());
        DESedeKeySpec spec = new DESedeKeySpec(encryptKey);
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DESede", "BC");
        Key key = kf.generateSecret(spec);
        Assert.assertArrayEquals(expected, ConnectorCryptoUtils.decrypt(key, "DESede/ECB/PKCS5Padding", encryptedBytes));

    }
}
