package be.ehealth.technicalconnector.session;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.service.sts.utils.SAMLConverter;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

/**
 * Session Management Service Integration Tests This test shows the use of the Session Management Service through the use of the Business
 * Connector
 * 
 * @author EHP
 */
public class SessionManagerIntegrationTest extends AbstractSessionManagerIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(SessionManagerIntegrationTest.class);
    
    public static SessionRule rule = SessionRule.withInactiveSession().build();

    @Test
    public void testCreateFallbackSessionWithEnc() throws Exception {

        SessionManager sessionmgmgt = Session.getInstance();

        sessionmgmgt.unloadSession();
        SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
        String token = SAMLConverter.toXMLString(session.getSAMLToken().getAssertion());

        LOG.debug(token);

        Assert.assertNotNull(token);
        Assert.assertEquals(true, sessionmgmgt.hasValidSession());
        Assert.assertNotNull(session.getEncryptionCredential());


    }

 
    @Test
    public void testLoadSessionWithEnc() throws Exception {

        SessionManager sessionmgmgt = Session.getInstance();
        sessionmgmgt.unloadSession();
        SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
        SAMLToken token = session.getSAMLToken();
        sessionmgmgt.unloadSession();
        session = sessionmgmgt.getSession();
        Assert.assertEquals(false, sessionmgmgt.hasValidSession());
        Assert.assertNull(session.getEncryptionCredential());
        Assert.assertNull(session.getHolderOfKeyCredential());

        sessionmgmgt.loadSession(token, props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));

        Assert.assertNotNull(token);
        Assert.assertEquals(true, sessionmgmgt.hasValidSession());
        Assert.assertNotNull(session.getEncryptionCredential());


    }

}
