/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.service.impl;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.responses.PutTherapeuticLinkResponse;
import be.ehealth.businessconnector.therlink.mappers.MapperFactory;
import be.ehealth.businessconnector.therlink.mappers.RequestObjectMapper;
import be.ehealth.businessconnector.therlink.mappers.ResponseObjectMapper;
import be.ehealth.businessconnector.therlink.session.TherlinkSessionServiceFactory;
import be.ehealth.businessconnector.therlink.util.TherlinkTestUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;

/**
 * @author EH076
 *
 */
public class TherapeuticLinkNewReferralTypesIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    @BeforeClass
    public static void checkEidPresent() {
        AssumeTools.isEIDEnabled();
    }

    @Test
    public void testReferralWithNewType() throws Exception {
        RequestObjectBuilder requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();
        RequestObjectMapper requestObjectMapper = MapperFactory.getRequestObjectMapper();
        ResponseObjectMapper responseObjectMapper = MapperFactory.getResponseObjectMapper();

        String comment = "testing referral to dentist with new referral type";
        // DateTime endDate = null;
        String type = "referral";
        @SuppressWarnings("deprecation")
        HcParty referralParty = new HcParty.Builder().withType("persdentist").withInss("20010100108").build();
        be.ehealth.businessconnector.therlink.domain.requests.PutTherapeuticLinkRequest createPutTherapeuticLinkRequest = requestObjectBuilder.createPutTherapeuticLinkRequest(null, TherlinkTestUtils.getPatientFromEid(), referralParty, type, comment, TherlinkTestUtils.getEidSigningProof());
        be.fgov.ehealth.hubservices.core.v2.PutTherapeuticLinkRequest mapPutTherapeuticLinkRequest = requestObjectMapper.mapPutTherapeuticLinkRequest(createPutTherapeuticLinkRequest);
        PutTherapeuticLinkResponse putResponse = responseObjectMapper.mapJaxbToPutTherapeuticLinkResponse(TherlinkSessionServiceFactory.getTherlinkService().putTherapeuticLink(mapPutTherapeuticLinkRequest));
        TherlinkTestUtils.validateResponse(null, putResponse);
    }

}
