/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.security;

import java.util.List;

import javax.xml.bind.JAXB;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Integration test for {@link HubRequestWithEncryption}
 * 
 * @author EHP
 * 
 */
public class HubRequestWithEncryptionIntegrationTest {

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.intrahub.test.properties");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }


    /**
     * @throws Exception
     */
    @Test
    public void testHubRequest() throws Exception {
        HubRequestHandler baseHandler = new HubRequestDoctor();
        HubRequestWithEncryption<PutTransactionRequest> encHandler = new HubRequestWithEncryption<PutTransactionRequest>(baseHandler);
        RequestType req = encHandler.handle();
        List<HcpartyType> partiesList = req.getAuthor().getHcparties();
        boolean containsEncryption = false;
        for (HcpartyType hcpartyType : partiesList) {
            if (hcpartyType.getFirstname() != null) {
                for (IDHCPARTY hcparty : hcpartyType.getIds()) {
                    if (hcparty.getS().compareTo(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR) == 0) {
                        containsEncryption = true;
                    }
                }
            }
        }
        Assert.assertTrue(containsEncryption);

        JAXB.marshal(req, System.out);
    }
}
