/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.builders;

import be.ehealth.technicalconnector.utils.XSDDateTimeConverter;
import be.fgov.ehealth.hubservices.core.v1.AccessRightListType;
import be.fgov.ehealth.hubservices.core.v1.AccessRightType;
import be.fgov.ehealth.hubservices.core.v1.ConsentHCPartyType;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.FolderType;
import be.fgov.ehealth.hubservices.core.v1.FolderTypeUnbounded;
import be.fgov.ehealth.hubservices.core.v1.HCPartyAdaptedType;
import be.fgov.ehealth.hubservices.core.v1.HCPartyIdType;
import be.fgov.ehealth.hubservices.core.v1.KmehrHeaderDeclareTransaction;
import be.fgov.ehealth.hubservices.core.v1.KmehrHeaderGetTransactionList;
import be.fgov.ehealth.hubservices.core.v1.LocalSearchType;
import be.fgov.ehealth.hubservices.core.v1.PatientIdType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetHCPartyPatientConsentType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetPatientAuditTrailType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetPatientConsentType;
import be.fgov.ehealth.hubservices.core.v1.SelectRevokeAccessRightType;
import be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType;
import be.fgov.ehealth.hubservices.core.v1.TransactionAccessListType;
import be.fgov.ehealth.hubservices.core.v1.TransactionBaseType;
import be.fgov.ehealth.hubservices.core.v1.TransactionIdType;
import be.fgov.ehealth.hubservices.core.v1.TransactionSummaryType;
import be.fgov.ehealth.hubservices.core.v1.TransactionWithPeriodType;
import be.fgov.ehealth.hubservices.core.v1.TransactionWithSpecificTime;
import be.fgov.ehealth.hubservices.core.v1.Transactionaccess;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDACCESSRIGHT;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDACCESSRIGHTschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDACCESSRIGHTvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDADDRESS;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDADDRESSschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENT;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONSENTvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCOUNTRY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCOUNTRYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDENCRYPTIONMETHOD;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDENCRYPTIONMETHODschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDENCRYPTIONMETHODvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEX;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEXvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSTANDARD;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINK;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTHERAPEUTICLINKschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTION;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTIONschemes;
import be.fgov.ehealth.standards.kmehr.dt.v1.TextType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHR;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHRschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AddressType;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Base64EncryptedDataType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Base64EncryptedValueType;
import be.fgov.ehealth.standards.kmehr.schema.v1.CountryType;
import be.fgov.ehealth.standards.kmehr.schema.v1.DateType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HeaderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.standards.kmehr.schema.v1.Nationality;
import be.fgov.ehealth.standards.kmehr.schema.v1.PersonType;
import be.fgov.ehealth.standards.kmehr.schema.v1.RecipientType;
import be.fgov.ehealth.standards.kmehr.schema.v1.SenderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.SexType;
import be.fgov.ehealth.standards.kmehr.schema.v1.StandardType;
import be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType;


/**
 * Object builder for test objects (used for assertions).
 * 
 * @author EHP
 * 
 */
public final class TestObjectBuilder {


    private TestObjectBuilder() {
        // Object builder for test purpose no constructor needed.
    }

    /**
     * Creates a KmehrHeaderDeclareTransaction
     * 
     * @return the KmehrHeader for DeclareTransaction
     */
    public static KmehrHeaderDeclareTransaction getKmehrHeaderDeclareTransaction() {
        KmehrHeaderDeclareTransaction result = new KmehrHeaderDeclareTransaction();
        FolderType folder = new FolderType();
        result.setFolder(folder);

        folder.setPatient(getPatientIdType());
        folder.setTransaction(getTransaction());

        return result;
    }

    /**
     * Creates a PatientIdType
     * 
     * @return the patient id type
     */
    public static PatientIdType getPatientIdType() {
        PatientIdType result = new PatientIdType();
        result.getIds().add(getIDPATIENT());
        return result;
    }

    /**
     * Creates an IDPATIENT with
     * 
     * @return the patient id
     */
    public static IDPATIENT getIDPATIENT() {
        IDPATIENT result = new IDPATIENT();
        result.setS(IDPATIENTschemes.INSS);
        result.setSV("1.0");
        result.setValue("05040199999");
        return result;
    }

    /**
     * Creates a TransactionSummaryType
     * 
     * @return the TransactionSummaryType
     */
    public static TransactionSummaryType getTransactionNoName() {
        TransactionSummaryType result = new TransactionSummaryType();
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("12:00:00"));
        CDTRANSACTION cd = new CDTRANSACTION();
        cd.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        cd.setSV("1.0");
        cd.setValue("result");
        result.getCds().add(cd);

        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.LOCAL);
        id.setSV("1.0");
        id.setSL("DuTestService237");
        id.setValue("71099911.102");
        result.getIds().add(id);

        result.setIscomplete(true);
        result.setIsvalidated(true);
        result.setRecorddatetime(XSDDateTimeConverter.parseXSDDateTime("2009-11-17T16:03:57"));

        result.setAuthor(getAuthorHospitalPersPhysicianNoName());

        return result;
    }

    /**
     * Creates a TransactionSummaryType
     * 
     * @return the TransactionSummaryType
     */
    public static TransactionSummaryType getTransaction() {
        TransactionSummaryType result = new TransactionSummaryType();
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("12:00:00"));
        CDTRANSACTION cd = new CDTRANSACTION();
        cd.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        cd.setSV("1.0");
        cd.setValue("result");
        result.getCds().add(cd);

        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.LOCAL);
        id.setSV("1.0");
        id.setSL("DuTestService237");
        id.setValue("71099911.102");
        result.getIds().add(id);

        result.setIscomplete(true);
        result.setIsvalidated(true);
        result.setRecorddatetime(XSDDateTimeConverter.parseXSDDateTime("2009-11-17T16:03:57"));

        result.setAuthor(getAuthorHospitalPersPhysician());

        return result;
    }

    /**
     * Creates an AuthorType with a hcPartyHospital
     * 
     * @return the author type
     */
    public static AuthorType getAuthorHospital() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyHospital());
        return result;
    }

    /**
     * Creates an AuthorType with a hcPartyHospital and a hcPartyPersPhysician
     * 
     * @return the AuthorType
     */
    public static AuthorType getAuthorHospitalPersPhysician() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyHospital());
        result.getHcparties().add(getHcPartyPersPhysician());
        return result;
    }

    /**
     * Creates an AuthorType with a HcPartyHospital and a HcPartyPersPhysician with no name
     * 
     * @return the AuthorType
     */
    public static AuthorType getAuthorHospitalPersPhysicianNoName() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyHospital());
        result.getHcparties().add(getHcPartyPersPhysicianNoName());
        return result;
    }

    /**
     * Creates a HcPartyPersPhysician
     * 
     * @return
     */
    private static HcpartyType getHcPartyPersPhysician() {
        HcpartyType result = getHcPartyPersPhysicianNoName();
        result.setFamilyname("LeHéros");
        result.setFirstname("Toto");
        return result;
    }

    /**
     * Creates a HcPartyType with non name
     * 
     * @return
     */
    private static HcpartyType getHcPartyPersPhysicianNoName() {
        HcpartyType result = new HcpartyType();

        CDHCPARTY cd = new CDHCPARTY();
        cd.setSV("1.1");
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setValue("persphysician");
        result.getCds().add(cd);

        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("10082555045");
        result.getIds().add(id1);

        IDHCPARTY id2 = new IDHCPARTY();
        id2.setS(IDHCPARTYschemes.INSS);
        id2.setSV("1.0");
        id2.setValue("71050643439");
        result.getIds().add(id2);

        return result;
    }

    /**
     * Creates a HcPartyType with only IDs
     * 
     * @return
     */
    private static be.fgov.ehealth.hubservices.core.v1.HcpartyType getHcPartyTypeOnlyIDs() {
        be.fgov.ehealth.hubservices.core.v1.HcpartyType result = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("10082555045");
        result.getIds().add(id1);

        IDHCPARTY id2 = new IDHCPARTY();
        id2.setS(IDHCPARTYschemes.INSS);
        id2.setSV("1.0");
        id2.setValue("71050643439");
        result.getIds().add(id2);

        return result;
    }

    /**
     * Creates a HcPartyHospital
     * 
     * @return
     */
    private static HcpartyType getHcPartyHospital() {
        HcpartyType result = new HcpartyType();
        result.setName("Hôpital DuTest");
        CDHCPARTY cd = new CDHCPARTY();
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setSV("1.1");
        cd.setValue("orghospital");
        result.getCds().add(cd);
        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        id.setValue("71099911");
        result.getIds().add(id);
        return result;
    }

    /**
     * Creates a KmehrMessage
     * 
     * @return the kmehrmessage
     */
    public static Kmehrmessage getKmehrmessage() {
        Kmehrmessage result = new Kmehrmessage();
        result.setHeader(getHeader());
        result.getFolders().add(getFolder());
        return result;
    }

    /**
     * Creates a HeaderType
     * 
     * @return
     */
    private static HeaderType getHeader() {
        HeaderType result = new HeaderType();
        SenderType sender = new SenderType();
        sender.getHcparties().add(getHcPartyPersPhysician());
        result.setSender(sender);
        RecipientType recipient = new RecipientType();
        recipient.getHcparties().add(getHcPartyPersPhysician());
        result.getRecipients().add(recipient);
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("12:00:00"));
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.ID_KMEHR);
        id.setSV("1.0");
        id.setValue("71050643439.456");
        result.getIds().add(id);
        StandardType standard = new StandardType();
        CDSTANDARD cd = new CDSTANDARD();
        cd.setSV("1.0");
        cd.setS("CD-STANDARD");
        cd.setValue("20090101");
        standard.setCd(cd);
        result.setStandard(standard);
        return result;
    }

    /**
     * Creates a FolderType
     * 
     * @return
     */
    private static be.fgov.ehealth.standards.kmehr.schema.v1.FolderType getFolder() {
        be.fgov.ehealth.standards.kmehr.schema.v1.FolderType result = new be.fgov.ehealth.standards.kmehr.schema.v1.FolderType();
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.ID_KMEHR);
        id.setSV("1.0");
        id.setValue("71050643439.954");
        result.getIds().add(id);
        result.setPatient(getPersonType());
        result.getTransactions().add(getTransactionType());
        return result;
    }

    /**
     * Creates a PErsonType
     * 
     * @return
     */
    private static PersonType getPersonType() {
        PersonType result = new PersonType();
        result.setFamilyname("Dupont");
        result.getFirstnames().add("George");
        IDPATIENT id = new IDPATIENT();
        id.setS(IDPATIENTschemes.INSS);
        id.setSV("1.0");
        id.setValue("44070200337");
        result.getIds().add(id);
        SexType sex = new SexType();
        CDSEX cd = new CDSEX();
        cd.setValue(CDSEXvalues.MALE);
        cd.setS("CD-SEX");
        cd.setSV("1.0");
        sex.setCd(cd);
        result.setSex(sex);
        return result;
    }

    /**
     * Creates a TransactionType
     * 
     * @return the TransactionType
     */
    private static TransactionType getTransactionType() {
        TransactionType result = new TransactionType();
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("237");
        id.setSL("MyHomeTool");
        result.getIds().add(id);

        CDTRANSACTION cd = new CDTRANSACTION();
        cd.setValue("sumehr");
        cd.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        cd.setSV("1.0");
        result.getCds().add(cd);

        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("12:00:00"));
        result.setIscomplete(true);
        result.setIsvalidated(true);
        result.setRecorddatetime(XSDDateTimeConverter.parseXSDDateTime("2009-11-17T16:03:57"));
        TextType text = new TextType();
        text.setValue("text");
        text.setL("EN");
        result.getText().add(text);

        result.setAuthor(getAuthorPersPhysician());
        return result;
    }

    /**
     * Creates an AuthorType with a PersPhysician
     * 
     * @return the AuthorType
     */
    public static AuthorType getAuthorPersPhysician() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyPersPhysician());
        return result;
    }

    /**
     * Creates an AuthorType with a PersPhysician with no name
     * 
     * @return the AuthorType
     */
    public static AuthorType getAuthorPersPhysicianWithNoName() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyPersPhysicianNoName());
        return result;
    }

    /**
     * Creates a TransactionIdType
     * 
     * @return the TransactionIdType
     */
    public static TransactionIdType getTransactionIdType() {
        TransactionIdType result = new TransactionIdType();
        IDKMEHR id = new IDKMEHR();
        id.setValue("71099911.102");
        id.setS(IDKMEHRschemes.LOCAL);
        id.setSV("1.0");
        id.setSL("DuTestService237");
        result.getIds().add(id);
        return result;
    }

    /**
     * Creates a TransactionWithPeriodType
     * 
     * @return the TransactionWithPeriodType
     */
    public static TransactionWithPeriodType getTransactionWithPeriodType() {
        TransactionWithPeriodType result = new TransactionWithPeriodType();
        result.setBegindate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setAuthor(getAuthorPersPhysicianWithNoName());

        CDTRANSACTION t1 = new CDTRANSACTION();
        t1.setValue("result");
        t1.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        t1.setSV("1.0");
        result.getCds().add(t1);

        CDTRANSACTION t2 = new CDTRANSACTION();
        t2.setValue("dischargereport");
        t2.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        t2.setSV("1.0");
        result.getCds().add(t2);
        return result;
    }

    /**
     * Creates a TransactionBaseType
     * 
     * @return the TransactionBaseType
     */
    public static TransactionBaseType getTransactionBaseType() {
        TransactionBaseType result = new TransactionBaseType();
        IDKMEHR id = new IDKMEHR();
        id.setValue("1520");
        id.setS(IDKMEHRschemes.LOCAL);
        id.setSV("1.0");
        id.setSL("AnotherRouting123");
        result.setId(id);

        result.setAuthor(getAuthorHubHospitalPersPhysician());

        return result;
    }

    /**
     * Creates an AuthorType with a HcPartyHub, a HcPartyHospital and a HcPartyPersPhysician
     * 
     * @return the Author type
     */
    public static AuthorType getAuthorHubHospitalPersPhysician() {
        AuthorType result = new AuthorType();
        result.getHcparties().add(getHcPartyHub());
        result.getHcparties().add(getHcPartyHospital());
        result.getHcparties().add(getHcPartyPersPhysician());
        return result;
    }

    /**
     * Creates a HcPartyHub
     * 
     * @return the HcParty type
     */
    private static HcpartyType getHcPartyHub() {
        HcpartyType result = new HcpartyType();
        result.setName("Another hub");
        CDHCPARTY cd = new CDHCPARTY();
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setSV("1.1");
        cd.setValue("hub");
        result.getCds().add(cd);
        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        id.setValue("anotherhubId");
        result.getIds().add(id);
        return result;
    }

    /**
     * Creates a HcPartyAdaptedType
     * 
     * @return the HcPArtyAdaptedType
     */
    public static HCPartyAdaptedType getHCPartyAdaptedType() {
        HCPartyAdaptedType result = new HCPartyAdaptedType();
        result.setFamilyname("LeHéros");
        result.setFirstname("Toto");

        CDHCPARTY cd = new CDHCPARTY();
        cd.setSV("1.1");
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setValue("persphysician");
        result.getCds().add(cd);

        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("10082555045");
        result.getIds().add(id1);

        IDHCPARTY id2 = new IDHCPARTY();
        id2.setS(IDHCPARTYschemes.INSS);
        id2.setSV("1.0");
        id2.setValue("71050643439");
        result.getIds().add(id2);

        result.setRecorddatetime(XSDDateTimeConverter.parseXSDDateTime("2009-11-19T16:47:15"));

        return result;
    }

    /**
     * Creates a HcPartyIdType
     * 
     * @return the HcPartyIdType
     */
    public static HCPartyIdType getHCPartyIdType() {
        HCPartyIdType result = new HCPartyIdType();

        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("10082555045");
        result.getIds().add(id1);

        IDHCPARTY id2 = new IDHCPARTY();
        id2.setS(IDHCPARTYschemes.INSS);
        id2.setSV("1.0");
        id2.setValue("71050643439");
        result.getIds().add(id2);

        return result;
    }

    /**
     * Creates a full PersonType
     * 
     * @return the person type
     */
    public static PersonType getPersonTypeFull() {
        PersonType result = new PersonType();
        result.setFamilyname("Dupont");
        result.getFirstnames().add("Lulu");
        result.getFirstnames().add("Germaine");

        DateType bdate = new DateType();
        bdate.setDate(XSDDateTimeConverter.parseXSDDate("1971-09-09+01:00"));
        result.setBirthdate(bdate);

        SexType sex = new SexType();
        CDSEX cd = new CDSEX();
        cd.setValue(CDSEXvalues.FEMALE);
        cd.setS("CD-SEX");
        cd.setSV("1.0");
        sex.setCd(cd);
        result.setSex(sex);

        Nationality nat = new Nationality();
        CDCOUNTRY country = new CDCOUNTRY();
        country.setValue("be");
        country.setS(CDCOUNTRYschemes.CD_FED_COUNTRY);
        country.setSV("1.0");
        nat.setCd(country);
        result.setNationality(nat);

        AddressType address = new AddressType();
        address.setCity("Tournai");
        CountryType c = new CountryType();
        c.setCd(country);
        address.setCountry(c);
        CDADDRESS cdAdd = new CDADDRESS();
        cdAdd.setValue("home");
        cdAdd.setSV("1.0");
        cdAdd.setS(CDADDRESSschemes.CD_ADDRESS);
        address.getCds().add(cdAdd);
        address.setZip("7500");
        address.setStreet("Avenue Delmée");
        address.setHousenumber("237");
        result.getAddresses().add(address);

        result.setRecorddatetime(XSDDateTimeConverter.parseXSDDateTime("2009-11-19T10:45:12"));

        IDPATIENT id = new IDPATIENT();
        id.setS(IDPATIENTschemes.INSS);
        id.setSV("1.0");
        id.setValue("46090928091");
        result.getIds().add(id);
        return result;
    }

    /**
     * Creates a ConsentHcPartyType
     * 
     * @return the consentHcPartyType
     */
    public static ConsentHCPartyType getConsentHCPartyType() {
        ConsentHCPartyType result = new ConsentHCPartyType();
        result.setHcparty(getHCPartyIdType());
        result.setRevokedate(XSDDateTimeConverter.parseXSDDate("2010-01-14+02:00"));
        return result;
    }

    /**
     * creates a ConsentType
     * 
     * @return the consent type
     */
    public static ConsentType getConsentType() {
        ConsentType result = new ConsentType();
        CDCONSENT cd = new CDCONSENT();
        cd.setValue(CDCONSENTvalues.RETROSPECTIVE);
        cd.setS(CDCONSENTschemes.CD_CONSENTTYPE);
        cd.setSV("1.0");
        result.getCds().add(cd);
        result.setSigndate(XSDDateTimeConverter.parseXSDDate("2009-11-17+02:00"));
        result.setPatient(getPatientIdType());
        return result;
    }

    /**
     * Creates a SelectGetPatientConsentType
     * 
     * @return the SelectGetPAtientConsentType
     */
    public static SelectGetPatientConsentType getSelectGetPatientConsentType() {
        SelectGetPatientConsentType result = new SelectGetPatientConsentType();
        result.setPatient(getPatientIdType());
        return result;
    }

    /**
     * Creates a TherapeuticLinkType
     * 
     * @return the therapeutic link type
     */
    public static TherapeuticLinkType getTherapeuticLinkType() {
        TherapeuticLinkType result = new TherapeuticLinkType();
        result.setHcparty(getHCPartyIdType());
        result.setPatient(getPatientIdType());
        CDTHERAPEUTICLINK cd = new CDTHERAPEUTICLINK();
        cd.setValue("hospitalstay");
        cd.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
        cd.setSV("1.0");
        result.setCd(cd);
        result.setStartdate(XSDDateTimeConverter.parseXSDDate("2009-11-20+02:00"));
        return result;
    }

    /**
     * Creates a SelectGetHcPartyPatientConsentType
     * 
     * @return the SelectGetHcPartyPatientConsentType
     */
    public static SelectGetHCPartyPatientConsentType getSelectGetHCPartyPatientConsentType() {
        SelectGetHCPartyPatientConsentType result = new SelectGetHCPartyPatientConsentType();
        result.getPatientsAndHcparties().add(getPatientIdType());
        result.getPatientsAndHcparties().add(getHCPartyIdType());
        CDTHERAPEUTICLINK cd = new CDTHERAPEUTICLINK();
        cd.setValue("hospitalstay");
        cd.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
        cd.setSV("1.0");
        CDTHERAPEUTICLINK cd2 = new CDTHERAPEUTICLINK();
        cd2.setValue("hospitalstay");
        cd2.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
        cd2.setSV("1.0");
        result.getCds().add(cd);
        result.getCds().add(cd2);
        result.setBegindate(XSDDateTimeConverter.parseXSDDate("2009-06-01+01:00"));
        result.setEnddate(XSDDateTimeConverter.parseXSDDate("2010-01-01+02:00"));
        return result;
    }

    /**
     * Creates an AccessRightType
     * 
     * @return the AccessRightType
     */
    public static AccessRightType getAccessRightType() {
        AccessRightType result = new AccessRightType();
        result.setHcparty(getHcPartyTypeOnlyIDs());
        CDACCESSRIGHT cd = new CDACCESSRIGHT();
        cd.setValue(CDACCESSRIGHTvalues.ALLOW);
        cd.setS(CDACCESSRIGHTschemes.CD_ACCESSRIGHT);
        cd.setSV("1.0");
        result.setCd(cd);
        result.setTransaction(getTransactionIdType());
        return result;
    }

    /**
     * Creates a SelectRevokeAccessRightType
     * 
     * @return the SelectRevokeAccessRightType
     */
    public static SelectRevokeAccessRightType getSelectRevokeAccessRightType() {
        SelectRevokeAccessRightType result = new SelectRevokeAccessRightType();
        result.setTransaction(getTransactionIdType());
        return result;
    }

    /**
     * Creates a SelectGetPAtientAuditTrailType
     * 
     * @return the SelectGetPatientAuditTrailType
     */
    public static SelectGetPatientAuditTrailType getSelectGetPatientAuditTrailType() {
        SelectGetPatientAuditTrailType result = new SelectGetPatientAuditTrailType();
        result.setPatient(getPatientIdType());
        result.setHcparty(getHCPartyIdType());
        result.setBegindate(XSDDateTimeConverter.parseXSDDate("2009-10-01+02:00"));
        result.setEnddate(XSDDateTimeConverter.parseXSDDate("2009-12-31+02:00"));
        result.setSearchtype(LocalSearchType.LOCAL);
        return result;
    }

    /**
     * Creates a kmehr ID
     * 
     * @return the kmehr id
     */
    public static IDKMEHR getIDKMEHR() {
        IDKMEHR result = new IDKMEHR();
        result.setS(IDKMEHRschemes.ID_KMEHR);
        result.setSV("1.0");
        result.setValue("HUBid.20091120090927123");
        return result;
    }

    /**
     * Creates a full PatientIdType
     * 
     * @return the person id type
     */
    public static PatientIdType getPatientIdTypeFull() {
        PatientIdType result = new PatientIdType();
        result.getIds().add(getIDPATIENT());
        // result.
        return result;
    }

    /**
     * Creates a kmehrHeaderGetTransactionList
     * 
     * @return the kmehr header for GetTransactionList
     */
    public static KmehrHeaderGetTransactionList getKmehrHeaderGetTransactionList() {
        KmehrHeaderGetTransactionList response = new KmehrHeaderGetTransactionList();
        FolderTypeUnbounded folder = new FolderTypeUnbounded();
        folder.setPatient(getPersonTypeFullNoNationality());
        folder.getTransactions().add(getTransactionNoName());
        response.setFolder(folder);
        return response;
    }

    /**
     * Creates a full PErsonType with no nationality
     * 
     * @return the person type
     */
    public static PersonType getPersonTypeFullNoNationality() {
        PersonType result = new PersonType();
        result.setFamilyname("TEST");
        result.getFirstnames().add("PATIENT");

        DateType bdate = new DateType();
        bdate.setDate(XSDDateTimeConverter.parseXSDDate("2009-04-01+01:00"));
        result.setBirthdate(bdate);

        SexType sex = new SexType();
        CDSEX cd = new CDSEX();
        cd.setValue(CDSEXvalues.MALE);
        cd.setS("CD-SEX");
        cd.setSV("1.0");
        sex.setCd(cd);
        result.setSex(sex);

        CDCOUNTRY country = new CDCOUNTRY();
        country.setValue("be");
        country.setS(CDCOUNTRYschemes.CD_COUNTRY);
        country.setSV("1.0");

        AddressType address = new AddressType();
        address.setCity("BRUXELLES");
        CountryType c = new CountryType();
        c.setCd(country);
        address.setCountry(c);
        CDADDRESS cdAdd = new CDADDRESS();
        cdAdd.setValue("home");
        cdAdd.setSV("1.0");
        cdAdd.setS(CDADDRESSschemes.CD_ADDRESS);
        address.getCds().add(cdAdd);
        address.setZip("1000");
        address.setStreet("Place de test, 1");
        result.getAddresses().add(address);

        IDPATIENT id = new IDPATIENT();
        id.setS(IDPATIENTschemes.INSS);
        id.setSV("1.0");
        id.setValue("05040199999");
        result.getIds().add(id);
        return result;
    }

    /**
     * Creates a HeaderType for a response
     * 
     * @return
     */
    private static HeaderType getHeaderResponse() {
        HeaderType result = new HeaderType();
        SenderType sender = new SenderType();
        sender.getHcparties().add(getHcPartyPersPhysicianSenderResponse());
        result.setSender(sender);
        RecipientType recipient = new RecipientType();
        recipient.getHcparties().add(getHcPartyPersPhysicianRecipientResponse());
        result.getRecipients().add(recipient);
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-01-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("12:00:00"));
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.ID_KMEHR);
        id.setSV("1.0");
        id.setValue("71050643439.456");
        result.getIds().add(id);
        StandardType standard = new StandardType();
        CDSTANDARD cd = new CDSTANDARD();
        cd.setSV("1.0");
        cd.setS("CD-STANDARD");
        cd.setValue("20090101");
        standard.setCd(cd);
        result.setStandard(standard);
        return result;
    }

    /**
     * Creates a HcPartyType
     * 
     * @return
     */
    private static HcpartyType getHcPartyPersPhysicianSenderResponse() {
        HcpartyType result = new HcpartyType();
        CDHCPARTY cd = new CDHCPARTY();
        cd.setSV("1.1");
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setValue("orghospital");
        result.getCds().add(cd);

        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("71099812");
        result.getIds().add(id1);

        result.setName("Another Hospital");

        return result;
    }

    /**
     * Creates a HcPartyType
     * 
     * @return
     */
    private static HcpartyType getHcPartyPersPhysicianRecipientResponse() {
        HcpartyType result = getHcPartyPersPhysicianNoNameResponse();
        result.setFamilyname("POLLET");
        result.setFirstname("YVON");
        return result;
    }

    /**
     * Creates a HcPartyType with a PersPhysician with no name
     * 
     * @return the hcparty type
     */
    private static HcpartyType getHcPartyPersPhysicianNoNameResponse() {
        HcpartyType result = new HcpartyType();

        CDHCPARTY cd = new CDHCPARTY();
        cd.setSV("1.0");
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setValue("persphysician");
        cd.setL("fr");
        result.getCds().add(cd);

        IDHCPARTY id1 = new IDHCPARTY();
        id1.setS(IDHCPARTYschemes.ID_HCPARTY);
        id1.setSV("1.0");
        id1.setValue("15528017001");
        result.getIds().add(id1);

        return result;
    }

    /**
     * Creates a kmehrMessage (response)
     * 
     * @return the kmehrmessage
     */
    public static Kmehrmessage getKmehrmessageResponse() {
        Kmehrmessage result = new Kmehrmessage();
        result.setHeader(getHeaderResponse());
        Base64EncryptedDataType base64 = new Base64EncryptedDataType();
        CDENCRYPTIONMETHOD cd = new CDENCRYPTIONMETHOD();
        cd.setValue(CDENCRYPTIONMETHODvalues.CMS);
        cd.setS(CDENCRYPTIONMETHODschemes.CD_ENCRYPTION_METHOD);
        cd.setSV("1.0");
        base64.setCd(cd);
        Base64EncryptedValueType value = new Base64EncryptedValueType();
        String s = new String("R0lGODlhcgGSALMAAAQCAEMmCZtuMFQxDS8b");
        value.setValue(s.getBytes());
        base64.setBase64EncryptedValue(value);
        result.setBase64EncryptedData(base64);
        return result;
    }

    /**
     * Creates a ConsentHcPArtyType (response)
     * 
     * @return the consent hcparty type
     */
    public static ConsentHCPartyType getConsentHCPartyTypeResponse() {
        ConsentHCPartyType result = new ConsentHCPartyType();
        result.setHcparty(getHCPartyIdType());
        result.setSigndate(XSDDateTimeConverter.parseXSDDate("2009-11-19+02:00"));
        result.setAuthor(getAuthorHospital());
        return result;
    }

    /**
     * Creates a ConsentType(response)
     * 
     * @return the consent type
     */
    public static ConsentType getConsentTypeResponse() {
        ConsentType result = new ConsentType();
        CDCONSENT cd = new CDCONSENT();
        cd.setValue(CDCONSENTvalues.RETROSPECTIVE);
        cd.setS(CDCONSENTschemes.CD_CONSENTTYPE);
        cd.setSV("1.0");
        result.getCds().add(cd);
        result.setSigndate(XSDDateTimeConverter.parseXSDDate("2009-11-17+02:00"));
        result.setPatient(getPatientIdType());
        result.setAuthor(getAuthorHospital());
        return result;
    }

    /**
     * Creates an AccessRightListType
     * 
     * @return the acces right list type
     */
    public static AccessRightListType getAccessRightListType() {
        AccessRightListType response = new AccessRightListType();
        response.getAccessrights().add(getAccessRightType());
        response.getAccessrights().add(getAccessRightTypePsy());
        return response;
    }

    /**
     * Creates an AccessRightType
     * 
     * @return
     */
    private static AccessRightType getAccessRightTypePsy() {
        AccessRightType result = new AccessRightType();
        result.setHcparty(getHcPartyTypePsy());
        CDACCESSRIGHT cd = new CDACCESSRIGHT();
        cd.setValue(CDACCESSRIGHTvalues.ALLOW);
        cd.setS(CDACCESSRIGHTschemes.CD_ACCESSRIGHT);
        cd.setSV("1.0");
        result.setCd(cd);
        result.setTransaction(getTransactionIdType());
        return result;
    }

    /**
     * Creates a HcPartyType
     * 
     * @return
     */
    private static be.fgov.ehealth.hubservices.core.v1.HcpartyType getHcPartyTypePsy() {
        be.fgov.ehealth.hubservices.core.v1.HcpartyType result = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
        CDHCPARTY cd = new CDHCPARTY();
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setSV("1.0");
        cd.setValue("deptpsychiatry");
        result.getCds().add(cd);
        return result;
    }

    /**
     * Creates a TransactionAccesSListType
     * 
     * @return the transaction access list type
     */
    public static TransactionAccessListType getTransactionAccessListType() {
        TransactionAccessListType result = new TransactionAccessListType();
        result.getTransactionaccesses().add(getTransactionAccess1());
        result.getTransactionaccesses().add(getTransactionAccess2());
        return result;
    }

    /**
     * Creates a TransactionAccess
     * 
     * @return
     */
    private static Transactionaccess getTransactionAccess2() {
        Transactionaccess result = new Transactionaccess();
        result.setAccessdatetime(XSDDateTimeConverter.parseXSDDateTime("2009-12-15T15:23:54"));
        result.setPatient(getPatientIdType());
        result.setTransaction(getTransactionWithSpecificTime2());
        result.getHcparties().add(getHcPartyPersPhysician());
        return result;
    }

    /**
     * Creates a TransactionAccess
     * 
     * @return
     */
    private static Transactionaccess getTransactionAccess1() {
        Transactionaccess result = new Transactionaccess();
        result.setAccessdatetime(XSDDateTimeConverter.parseXSDDateTime("2009-12-15T15:23:54"));
        result.setPatient(getPatientIdType());
        result.setTransaction(getTransactionWithSpecificTime1());
        result.getHcparties().add(getHcPartyPersPhysician());
        return result;
    }

    /**
     * Creates a TransactionWithSpecificTime
     * 
     * @return
     */
    private static TransactionWithSpecificTime getTransactionWithSpecificTime1() {
        TransactionWithSpecificTime result = new TransactionWithSpecificTime();
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-11-01+02:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("14:50:08"));
        result.setAuthor(getAuthorHospitalPersPhysicianNoName());
        result.getIds().add(getIDKMEHRTx1());
        result.getCds().add(getTransactionCD());
        return result;
    }

    /**
     * Creates a TransactionWithSpecificType
     * 
     * @return
     */
    private static TransactionWithSpecificTime getTransactionWithSpecificTime2() {
        TransactionWithSpecificTime result = new TransactionWithSpecificTime();
        result.setDate(XSDDateTimeConverter.parseXSDDate("2009-10-14+01:00"));
        result.setTime(XSDDateTimeConverter.parseXSDTime("09:15:32"));
        result.setAuthor(getAuthorHospitalPersPhysicianNoName());
        result.getIds().add(getIDKMEHRTx2());
        result.getCds().add(getTransactionCD());
        return result;
    }

    /**
     * Creates a CDTransaction
     * 
     * @return the transaction type
     */
    private static CDTRANSACTION getTransactionCD() {
        CDTRANSACTION result = new CDTRANSACTION();
        result.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        result.setSV("1.0");
        result.setValue("result");
        return result;
    }

    /**
     * Creates an IDKmehr with value 71099911.102
     * 
     * @return the idkmehr
     */
    public static IDKMEHR getIDKMEHRTx1() {
        IDKMEHR result = new IDKMEHR();
        result.setS(IDKMEHRschemes.LOCAL);
        result.setSV("1.0");
        result.setSL("DuTestService237");
        result.setValue("71099911.102");
        return result;
    }

    /**
     * Creates an IDKmehr with value 71099911.658
     * 
     * @return the idkmehr
     */
    public static IDKMEHR getIDKMEHRTx2() {
        IDKMEHR result = new IDKMEHR();
        result.setS(IDKMEHRschemes.LOCAL);
        result.setSV("1.0");
        result.setSL("DuTestService237");
        result.setValue("71099911.658");
        return result;
    }
}
