/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genins.domain;

import java.util.Calendar;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.mycarenetcommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetcommons.domain.Period;
import be.fgov.ehealth.genericinsurability.core.v1.InsurabilityContactTypeType;
import be.fgov.ehealth.genericinsurability.core.v1.InsurabilityRequestTypeType;


/**
 * @author EH054
 */
public class RequestParametersTest {

    @Test
    public void testGetButNotInitialized() {
        RequestParameters empty = new RequestParameters();
        Assert.assertNull(empty.getInss());
        Assert.assertNull(empty.getInsurabilityReference());
        Assert.assertNull(empty.getMutuality());
        Assert.assertNull(empty.getRegNrWithMut());
        Assert.assertNull(empty.getCareReceiver());
        Assert.assertNull(empty.getInsurabilityContactType());
        Assert.assertNull(empty.getInsurabilityRequestType());
        Assert.assertNull(empty.getPeriod());
        Assert.assertNull(empty.getPeriodEnd());
        Assert.assertNull(empty.getPeriodStart());
        Assert.assertNull(empty.getReferenceDate());
    }

    @Test
    public void testGetAndSet() {
        RequestParameters parameter = new RequestParameters();

        parameter.setInss("91121208397");
        parameter.setMutuality("1");
        parameter.setRegNrWithMut("112");
        CareReceiverId careReceiverId = new CareReceiverId("91121208397", "112", "1");
        parameter.setInss("91121208397");
        parameter.setMutuality("1");
        parameter.setRegNrWithMut("112");
        
        parameter.setCareReceiver(careReceiverId);

        parameter.setInsurabilityContactType(InsurabilityContactTypeType.HOSPITALIZED_FOR_DAY);
        parameter.setInsurabilityRequestType(InsurabilityRequestTypeType.INFORMATION);
        parameter.setInsurabilityReference("1");

        Calendar c = Calendar.getInstance();
        DateTime periodStart = new DateTime(c.getTime());
        parameter.setPeriodStart(periodStart);
        
        parameter.setPeriod(null);
        c.add(Calendar.MONTH, 1);
        DateTime periodEnd = new DateTime(c.getTime());
        parameter.setPeriodEnd(periodEnd);
        
        
        parameter.setPeriod(new Period(periodStart, periodEnd));
        parameter.setPeriodStart(periodStart);
        parameter.setPeriodEnd(periodEnd);
        
        DateTime dateTime = new DateTime(Calendar.getInstance().getTime());
        parameter.setReferenceDate(dateTime);


        Assert.assertEquals("91121208397", parameter.getInss());
        Assert.assertEquals("1", parameter.getInsurabilityReference());
        Assert.assertEquals("1", parameter.getMutuality());
        Assert.assertEquals("112", parameter.getRegNrWithMut());
        Assert.assertNotNull(parameter.getCareReceiver());
        Assert.assertEquals(InsurabilityContactTypeType.HOSPITALIZED_FOR_DAY, parameter.getInsurabilityContactType());
        Assert.assertEquals(InsurabilityRequestTypeType.INFORMATION, parameter.getInsurabilityRequestType());
        Assert.assertNotNull(parameter.getPeriod());
        Assert.assertEquals(periodEnd, parameter.getPeriodEnd());
        Assert.assertEquals(periodStart, parameter.getPeriodStart());
        Assert.assertEquals(dateTime, parameter.getReferenceDate());
    }

}
