/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.AbstractSignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.DomUtils;
import be.fgov.ehealth.technicalconnector.signature.impl.SignatureUtils;
import be.fgov.ehealth.technicalconnector.signature.impl.extractor.ForkedExtractor;
import be.fgov.ehealth.technicalconnector.signature.impl.extractor.SecurityTokenReferenceExtractor;
import be.fgov.ehealth.technicalconnector.signature.impl.extractor.X509DataExctractor;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.XadesSpecification;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.QualifyingPropertiesBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.UnsignedPropertiesBuilder;
import be.fgov.ehealth.technicalconnector.signature.resolvers.DocumentResolver;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureBuilder
extends AbstractSignatureBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignatureBuilder.class);
    private XadesSpecification[] specs;
    private AdvancedElectronicSignatureEnumeration aes;

    public XmlSignatureBuilder(AdvancedElectronicSignatureEnumeration aes, XadesSpecification ... specs) {
        this.specs = specs;
        this.aes = aes;
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteArrayToSign) throws TechnicalConnectorException {
        return this.sign(signatureCredential, byteArrayToSign, new HashMap<String, Object>());
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteArrayToSign, Map<String, Object> options) throws TechnicalConnectorException {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (options != null) {
            optionMap.putAll(options);
        }
        this.validateInput(signatureCredential, byteArrayToSign);
        try {
            String baseURI = SignatureUtils.getOption("baseURI", optionMap, "");
            String signatureMethodURI = SignatureUtils.getOption("signatureMethodURI", optionMap, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            String canonicalizationMethodURI = SignatureUtils.getOption("canonicalizationMethodURI", optionMap, "http://www.w3.org/2001/10/xml-exc-c14n#");
            List transformerList = SignatureUtils.getOption("transformerList", optionMap, new ArrayList());
            String digestURI = SignatureUtils.getOption("digestURI", optionMap, "http://www.w3.org/2001/04/xmlenc#sha256");
            boolean encapsulate = SignatureUtils.getOption("encapsulate", optionMap, Boolean.FALSE);
            if (encapsulate && !transformerList.contains("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                transformerList.add(0, "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            } else if (!encapsulate && transformerList.contains("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                encapsulate = true;
            }
            Document doc = ConnectorXmlUtils.toDocument((byte[])byteArrayToSign);
            XMLSignature sig = new XMLSignature(doc, baseURI, signatureMethodURI, canonicalizationMethodURI);
            DocumentResolver resolver = new DocumentResolver(baseURI, doc);
            sig.addResourceResolver((ResourceResolverSpi)resolver);
            Transforms baseDocTransform = this.createDocumentTransform(transformerList, doc);
            sig.addDocument(XmlSignatureBuilder.ref(baseURI), baseDocTransform, digestURI);
            Transforms xadesTransform = new Transforms(doc);
            xadesTransform.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            ObjectContainer container = new ObjectContainer(sig.getDocument());
            sig.appendObject(container);
            if (signatureCredential instanceof SAMLToken) {
                SAMLToken token = (SAMLToken)signatureCredential;
                sig.getKeyInfo().addUnknownElement((Element)sig.getDocument().importNode(this.obtainSAMLTokenReference(token), true));
                container.appendChild((Node)((Element)sig.getDocument().importNode(token.getAssertion(), true)));
                Transforms samlToken = new Transforms(doc);
                samlToken.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String samlTokenURI = token.getAssertion().getAttribute("AssertionID");
                DocumentResolver samlTokenResolver = new DocumentResolver(samlTokenURI, ((SAMLToken)signatureCredential).getAssertion().getOwnerDocument());
                sig.addResourceResolver((ResourceResolverSpi)samlTokenResolver);
                sig.addDocument(XmlSignatureBuilder.ref(samlTokenURI), samlToken, digestURI, null, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (signatureCredential.getCertificateChain() != null) {
                for (Certificate cert : signatureCredential.getCertificateChain()) {
                    sig.addKeyInfo((X509Certificate)cert);
                }
            }
            String xadesUuid = IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
            QualifyingPropertiesBuilder qualProperties = new QualifyingPropertiesBuilder();
            for (XadesSpecification spec : this.specs) {
                spec.addOptionalBeforeSignatureParts(qualProperties.getSignedProps(), sig, signatureCredential, xadesUuid, options);
            }
            Document xadesQualPropertiesDocument = qualProperties.buildBeforeSigningAsDocument();
            Element xadesQualProperties = (Element)sig.getDocument().importNode(xadesQualPropertiesDocument.getDocumentElement(), true);
            container.appendChild((Node)xadesQualProperties);
            resolver.addDocument(qualProperties.getSignedProps().getId(), xadesQualPropertiesDocument);
            sig.addDocument(XmlSignatureBuilder.ref(qualProperties.getSignedProps().getId()), xadesTransform, digestURI, null, "http://uri.etsi.org/01903#SignedProperties");
            sig.sign((Key)signatureCredential.getPrivateKey());
            String xmldsigId = "xmldsig-" + xadesUuid;
            sig.setId(xmldsigId);
            xadesQualProperties.setAttribute("Target", XmlSignatureBuilder.ref(xmldsigId));
            UnsignedPropertiesBuilder unsignedProperties = new UnsignedPropertiesBuilder();
            unsignedProperties.setId(xadesUuid);
            for (XadesSpecification spec : this.specs) {
                spec.addOptionalAfterSignatureParts(unsignedProperties, sig, xadesUuid, options);
            }
            Document xadesUnsignedPropertiesDoc = unsignedProperties.buildAsDocument();
            if (xadesUnsignedPropertiesDoc != null) {
                Element xadesUnsignedProperties = (Element)sig.getDocument().importNode(unsignedProperties.buildAsDocument().getDocumentElement(), true);
                xadesQualProperties.appendChild(xadesUnsignedProperties);
            }
            if (encapsulate) {
                doc.getFirstChild().insertBefore(doc.adoptNode(sig.getElement()), null);
                return ConnectorXmlUtils.toByteArray((Node)doc);
            }
            return ConnectorXmlUtils.toByteArray((Node)sig.getElement());
        }
        catch (TransformationException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (XMLSignatureException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (XMLSecurityException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private Transforms createDocumentTransform(List<String> tranformerList, Document doc) throws TransformationException {
        Transforms baseDocTransform = new Transforms(doc);
        for (String transform : tranformerList) {
            baseDocTransform.addTransform(transform);
        }
        return baseDocTransform;
    }

    @Override
    public SignatureVerificationResult verify(byte[] signedByteArray, Map<String, Object> options) throws TechnicalConnectorException {
        Document signedContent = ConnectorXmlUtils.toDocument((byte[])signedByteArray);
        NodeList signatureList = DomUtils.getMatchingChilds(signedContent, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureList == null || signatureList.getLength() == 0) {
            LOG.info("No signature found in signedContent");
            SignatureVerificationResult result = new SignatureVerificationResult();
            result.getErrors().add(SignatureVerificationError.SIGNATURE_NOT_PRESENT);
            return result;
        }
        if (signatureList.getLength() > 1) {
            LOG.info("Multiple signature found, using first one.");
        }
        return this.verify(signedContent, (Element)signatureList.item(0), options);
    }

    @Override
    public SignatureVerificationResult verify(byte[] signedByteArray, byte[] signature, Map<String, Object> options) throws TechnicalConnectorException {
        Element sigElement = ConnectorXmlUtils.toElement((byte[])signature);
        Document signedContent = ConnectorXmlUtils.toDocument((byte[])signedByteArray);
        return this.verify(signedContent, sigElement, options);
    }

    public SignatureVerificationResult verify(Document signedContent, Element sigElement, Map<String, Object> options) throws TechnicalConnectorException {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (options != null) {
            optionMap.putAll(options);
        }
        SignatureVerificationResult result = new SignatureVerificationResult();
        NodeList signatureList = DomUtils.getMatchingChilds(signedContent, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureList == null || signatureList.getLength() == 0) {
            LOG.info("Adding signature to signedContent");
            signedContent.getFirstChild().appendChild(signedContent.importNode(sigElement, true));
        }
        this.verifyXmlDsigSignature(result, sigElement, signedContent, optionMap);
        this.verifyManifest(result, sigElement, optionMap);
        for (XadesSpecification spec : this.specs) {
            spec.verify(result, sigElement);
        }
        this.validateChain(result, options);
        return result;
    }

    private void verifyManifest(SignatureVerificationResult result, Element sigElement, Map<String, Object> options) {
        Boolean followNestedManifest = SignatureUtils.getOption("followNestedManifest", options, Boolean.FALSE);
        if (followNestedManifest.booleanValue()) {
            Element signedInfo = (Element)DomUtils.getMatchingChilds(sigElement, "http://www.w3.org/2000/09/xmldsig#", "SignedInfo").item(0);
            NodeList referencesList = DomUtils.getMatchingChilds(signedInfo, "http://www.w3.org/2000/09/xmldsig#", "Reference");
            for (int i = 0; i < referencesList.getLength(); ++i) {
                Element reference = (Element)referencesList.item(i);
                String refType = reference.getAttribute("Type");
                if (!refType.endsWith("Manifest") || refType.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#Manifest")) continue;
                result.getErrors().add(SignatureVerificationError.SIGNATURE_MANIFEST_COULD_NOT_BE_VERIFIED);
            }
        }
    }

    private void verifyXmlDsigSignature(SignatureVerificationResult result, Element sigElement, Document signedContent, Map<String, Object> options) {
        try {
            String uri = IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
            XMLSignature xmlSignature = new XMLSignature(sigElement, uri);
            Boolean followNestedManifest = SignatureUtils.getOption("followNestedManifest", options, Boolean.FALSE);
            xmlSignature.setFollowNestedManifests(followNestedManifest.booleanValue());
            xmlSignature.addResourceResolver((ResourceResolverSpi)new DocumentResolver(uri, signedContent));
            KeyInfo keyInfo = xmlSignature.getKeyInfo();
            keyInfo.setSecureValidation(false);
            ForkedExtractor extractor = new ForkedExtractor(new X509DataExctractor(), new SecurityTokenReferenceExtractor());
            result.getCertChain().addAll(extractor.extract(keyInfo));
            X509Certificate signingCert = this.extractEndCertificate(result.getCertChain());
            result.setSigningCert(signingCert);
            if (!xmlSignature.checkSignatureValue(signingCert)) {
                result.getErrors().add(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to verify XmlDsig Signature", (Throwable)e);
            result.getErrors().add(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
        }
    }

    private Element obtainSAMLTokenReference(SAMLToken signatureCredential) throws TechnicalConnectorException {
        String samlRef = ConnectorIOUtils.getResourceAsString((String)"/templates/keyinfo-saml1.1-reference.xml");
        samlRef = StringUtils.replace((String)samlRef, (String)"${assertionId}", (String)signatureCredential.getAssertion().getAttribute("AssertionID"));
        return ConnectorXmlUtils.toDocument((byte[])ConnectorIOUtils.toBytes((String)samlRef, (Charset)Charset.UTF_8)).getDocumentElement();
    }

    @Override
    public AdvancedElectronicSignatureEnumeration getSupportedAES() {
        return this.aes;
    }

    private static String ref(String id) {
        return "#" + id;
    }
}

