/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.ProviderAdaptor;
import be.ehealth.technicalconnector.service.sts.security.impl.beid.BeIDProviderAdaptor;
import java.security.AuthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderFactory.class);
    private static final String PROP_PROVIDER = "provider.class";
    private static final String DEFAULT_PROVIDER = BeIDProviderAdaptor.class.getName();
    private static Configuration config = ConfigFactory.getConfigValidator();

    private ProviderFactory() {
    }

    public static AuthProvider getProvider() throws TechnicalConnectorException {
        String providerClassName = config.getProperty(PROP_PROVIDER, DEFAULT_PROVIDER);
        try {
            Class<?> provider = Class.forName(providerClassName);
            Object providerObject = provider.newInstance();
            if (providerObject instanceof ProviderAdaptor) {
                return (AuthProvider)((ProviderAdaptor)providerObject).getProvider();
            }
            String msg = "Class with name [" + provider + "] is not an instance of RevocationStatusChecker, but an instance of [" + providerObject.getClass() + "]";
            LOG.debug(msg);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, msg);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, (Throwable)e, "Class could not be found : " + providerClassName);
        }
        catch (InstantiationException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, (Throwable)e, "InstantiationException for " + providerClassName + " : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, (Throwable)e, "Illegal acces exception while instanciation of " + providerClassName + " : " + e.getMessage());
        }
        catch (SecurityException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, (Throwable)e, "Security exception while instanciation of " + providerClassName + " : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROVIDER_INSTANCIATION, (Throwable)e, "Illegal argument exception while instanciation of " + providerClassName + " : " + e.getMessage());
        }
    }
}

