﻿using be.ehealth.technicalconnector.handler;
using javax.xml.soap;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.ws
{
    using System;
    using System.IO;
    using System.Text;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.config.impl;
    using be.ehealth.technicalconnector.exception;
    using be.ehealth.technicalconnector.service.sts.security;
    using be.ehealth.technicalconnector.service.sts.security.impl;
    using be.ehealth.technicalconnector.utils;
    using be.ehealth.technicalconnector.utils.net;
    using be.ehealth.technicalconnector.ws;
    using be.ehealth.technicalconnector.ws.domain;
    using be.ehealth.technicalconnector.ws.impl;

    using javax.xml.parsers;

    using NUnit.Framework;

    using org.w3c.dom;
    using org.xml.sax;

    /**
     * The Class GenericWsCertSecured.
     */
    [TestFixture]
    class GenericWSCertSecuredIntegrationTest
    {
        #region Fields

        private static java.util.Properties config;

        #endregion Fields

        #region Methods

        [SetUp]
        public static void init()
        {
            config = TestPropertiesLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",".net");
        }

        /**
         * Use the Generic Certificate Secured Web Service method to call Codage's encode operation
         *
         * This test includes the following main steps:
         * 1. Set the URL to the web service end-point
         * 2. Get the Certificate to use
         * 3. Get the payload
         * 4. Send the message
         *
         * @throws IOException Signals that an I/O exception has occurred.
         * @throws TechnicalConnectorException the technical connector exception
         * @throws ParserConfigurationException
         * @throws SAXException
         */
        [Test]
        public void testSendCertSecuredDOM()
        {
	        GenericRequest request = new GenericRequest();
	        // 1. Set the URL to the web service end-point
	        request.setEndpoint(config.getProperty("test.secured.endpoint"));
	
	        // 2. Get the Certificate to use
	        Credential credential = new KeyStoreCredential(config.getProperty("test.keystore.location"), config.getProperty("test.keystore.alias"), config.getProperty("test.keystore.password"));
	
	        request.getSecurityHandlerChain().add(new CertificateCallback(credential.getCertificate(), credential.getPrivateKey()));
	        request.getSecurityHandlerChain().add(new SoapActionHandler());
	        request.setDefaultHandlerChain();
	
	        // 3. Get the payload
	        request.setPayload(getPayload());
	
	        // 4. Send the message
	        GenericWsSender sender = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender();
	        Node result = null;
	        try {
	            result = sender.send(request).asNode();
	        } catch (SOAPException e) {
	            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, e, e.getMessage());
	        }
	        // check if something has been received
	        Assert.NotNull(result);
        }

        /**
         * Use the Generic Certificate Secured Web Service method to call Codage's encode operation
         *
         * This test includes the following main steps:
         * 1. Set the URL to the web service end-point
         * 2. Get the Certificate to use
         * 3. Get the payload
         * 4. Send the message
         *
         * @throws IOException Signals that an I/O exception has occurred.
         * @throws TechnicalConnectorException the technical connector exception
         */
        [Test]
        public void testSendCertSecuredString()
        {
	        GenericRequest request = new GenericRequest();
	        // 1. Set the URL to the web service end-point
	        request.setEndpoint(config.getProperty("test.secured.endpoint"));
	
	        // 2. Get the Certificate to use
	        Credential credential = new KeyStoreCredential(config.getProperty("test.keystore.location"), config.getProperty("test.keystore.alias"), config.getProperty("test.keystore.password"));
	
	        request.getSecurityHandlerChain().add(new CertificateCallback(credential.getCertificate(), credential.getPrivateKey()));
	        request.getSecurityHandlerChain().add(new SoapActionHandler());
	        request.setDefaultHandlerChain();
	
	        // 3. Get the payload
	        request.setPayload(getPayload());
	
	        // 4. Send the message
	        GenericWsSender sender = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender();
	        String result = null;
	        try {
	            result = sender.send(request).asString();
	        } catch (SOAPException e) {
	            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, e, e.getMessage());
	        }
	        // check if something has been received
	        Assert.NotNull(result);
        }

        /**
         * Helper method for testSendCertSecured
         * Read out the request from XML file
         *
         * @return the payload
         * @throws IOException Signals that an I/O exception has occurred.
         * @throws TechnicalConnectorException
         */
        private String getPayload()
        {
            // get the file where the XML request is stored
            String file = config.getProperty("test.xml.codage.request");

            // read out the XML request to string
            java.io.InputStream input = ConnectorIOUtils.getResourceAsStream("./"+file);
            String payload = ConnectorIOUtils.convertStreamToString(input);
            return payload;
        }

        #endregion Methods
    }
}