#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/*
 * Session Management Service Integration Tests This test shows the use of the Session Management Service through the use of the Business
 * Connector
 */
namespace be.ehealth.technicalconnector.session
{
    using System;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.service.sts.security;
    using be.ehealth.technicalconnector.service.sts.security.impl;
    using be.ehealth.technicalconnector.service.sts.utils;
    using be.ehealth.technicalconnector.utils;
    using be.ehealth.technicalconnector.utils.net;

    using java.lang;
    using java.util;

    using NUnit.Framework;

    using org.w3c.dom;

    [TestFixture]
    public class SessionManagerIntegrationTest
    {
        #region Fields

        private static Configuration conf;
        private static Properties props;

        #endregion Fields

        #region Methods

        [SetUp]
        public static void init()
        {
            props = TestPropertiesLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net");
            conf = ConfigFactory.getConfigValidator().getConfig();

            Iterator it = props.keySet().iterator();
            while (it.hasNext()) {
                string key = (string)it.next();
                if (!key.ToString().StartsWith("test.")) {
                    conf.setProperty(key.ToString(), props.getProperty(key.ToString()));
                }
            }
        }

        [Test]
        public void testCreateFallbackSessionWithEnc()
        {
            SessionManager sessionmgmgt = Session.getInstance();
            sessionmgmgt.unloadSession();
            SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
            string token = SAMLConverter.toXMLString(session.getSAMLToken().getAssertion());

            Assert.IsNotNull(token);
            Assert.AreEqual(true, sessionmgmgt.hasValidSession());
        }

        [Test]
        public void testCreateFallbackSessionWithoutEnc()
        {
            SessionManager sessionmgmgt = Session.getInstance();
            sessionmgmgt.unloadSession();
            SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"));
            string token = SAMLConverter.toXMLString(session.getSAMLToken().getAssertion());

            Assert.IsNotNull(token);
            Assert.AreEqual(true, sessionmgmgt.hasValidSession());
        }

        [Test]
        public void testLoadSessionWithEnc()
        {
            SessionManager sessionmgmgt = Session.getInstance();
            sessionmgmgt.unloadSession();
            SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"));
            SAMLToken token = session.getSAMLToken();
            sessionmgmgt.unloadSession();
            session = sessionmgmgt.getSession();
            Assert.AreEqual(false, sessionmgmgt.hasValidSession());
            Assert.IsNull(session.getEncryptionCredential());
            Assert.IsNull(session.getHolderOfKeyCredential());

            sessionmgmgt.loadSession(token, props.getProperty("test.session.holderofkey.password"), props.getProperty("test.session.encryption.password"));
            session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"));

            Assert.IsNotNull(token);
            Assert.AreEqual(true, sessionmgmgt.hasValidSession());
        }

        [Test]
        public void testLoadSessionWithoutEnc()
        {
            SessionManager sessionmgmgt = Session.getInstance();
            sessionmgmgt.unloadSession();
            SessionItem session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.holderofkey.password"));
            SAMLToken token = session.getSAMLToken();
            sessionmgmgt.unloadSession();
            session = sessionmgmgt.getSession();
            Assert.AreEqual(false, sessionmgmgt.hasValidSession());
            Assert.IsNull(session.getEncryptionCredential());
            Assert.IsNull(session.getHolderOfKeyCredential());

            sessionmgmgt.loadSession(token, props.getProperty("test.session.holderofkey.password"));
            session = sessionmgmgt.createFallbackSession(props.getProperty("test.session.encryption.password"));

            Assert.IsNotNull(token);
            Assert.AreEqual(true, sessionmgmgt.hasValidSession());
        }

        #endregion Methods
    }
}