using be.fgov.ehealth.technicalconnector.session;
#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.session
{
	using System;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.config.impl;
	using be.ehealth.technicalconnector.exception;
	using be.ehealth.technicalconnector.idgenerator;
	using be.ehealth.technicalconnector.service.sts;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.service.sts.utils;
	using be.ehealth.technicalconnector.session;
	using be.ehealth.technicalconnector.utils;
	using be.ehealth.technicalconnector.utils.net;

	using ikvm.extensions;

	using java.io;
	using java.util;

	using NUnit.Framework;

	using org.apache.commons.compress.utils;
	using org.apache.log4j;
	using org.w3c.dom;

	/// <summary>
	/// Description of AbstractServiceIntegrationTest.
	/// </summary>
	[TestFixture]
	public class AbstractServiceIntegrationTest
	{
		#region Fields

		protected static String DEFAULT_CONFIG_FILE = "be.ehealth.technicalconnector.properties";
		protected static String DEFAULT_SESSION_CONFIG_FILE = "be.ehealth.technicalconnector.test.properties";

		private static Properties props;

		#endregion Fields

		#region Methods

		/**
		 * @return the props
		 */
		public static Properties getSessionProps()
		{
			return props;
		}

		[SetUpAttribute]
		public static void init()
		{
			SessionDestroyer.destroy();
			init(true);
		}

		/**
		 *
		 * @param activateSession
		 * @throws Exception
		 */
		public static void init(bool activateSession)
		{
			initConfig(DEFAULT_CONFIG_FILE);
			loadSession(DEFAULT_SESSION_CONFIG_FILE, activateSession);
		}

		private static void initConfig(String location)
		{
			try {		
				File tempFile = File.createTempFile("SessionInitializer", "properties");
				tempFile.deleteOnExit();
				
				Properties props = TestPropertiesLoader.getProperties(location,".net");
				props.save(new FileOutputStream(tempFile),"");			

				ConfigFactory.setConfigLocation(tempFile.getAbsolutePath());
			} catch (Exception e) {
				throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, e.getMessage(), e);
			}
		}

		/**
		 * @param sessionPropsLocation
		 * @throws TechnicalConnectorException
		 * @throws SessionManagementException
		 * @throws Exception
		 */
		private static void loadSession(String sessionPropsLocation, bool initSession)
		{
			props = TestPropertiesLoader.getProperties(sessionPropsLocation,".net");

			// set to TRUE to use eID
			// FALSE to use fallback session
			bool useEID = false;
			// If fallback session is the wanted scenario, provide the needed information below.
			// The INSS of the user for which the fallback session should be created and the password to access the keystore.
			String idenPK = props.getProperty("test.session.identification.password");
			String hokPK = props.getProperty("test.session.holderofkey.password");
			String encPK = props.getProperty("test.session.encryption.password");

			Iterator it = props.keySet().iterator();
			while (it.hasNext()) {
				Object keyObj = it.next();
				String key = keyObj.toString();
				if (!key.startsWith("test.")) {
					System.Console.WriteLine("Adding key to ConfigFactory:" + key);
					ConfigFactory.getConfigValidator().getConfig().setProperty(key, props.getProperty(key));
				}
			}

			System.Console.WriteLine("Starting new session");
			if (initSession) {
				// create session
				// load session management service
				SessionManager sessionmgmt = Session.getInstance();
				// check if there is already a session, if not: create a session
				if (!sessionmgmt.hasValidSession()) {
					// use the eID or the fallback session mechanism
					if (useEID) {
						sessionmgmt.createSession(hokPK, encPK);
					} else {
						System.Console.WriteLine("Creating fallback session.");
						// use fallback mechanism with previously provided details
						sessionmgmt.createFallbackSession(idenPK, hokPK, encPK);
					}
				}
			}
		}

		#endregion Methods
	}
}