﻿#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * Codage Service Integration Tests
 * This set of tests shows the use of the Codage Service through the use of the Technical Connector
 */
namespace be.ehealth.technicalconnector.service.sso
{
	using System;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.enumeration;
	using be.ehealth.technicalconnector.exception;
	using be.ehealth.technicalconnector.service;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.utils;
	using be.ehealth.technicalconnector.utils.net;
	using be.fgov.ehealth.seals.core.v1;
	using be.fgov.ehealth.seals.protocol.v1;
	using be.ehealth.technicalconnector.session;

	using java.util;

	using NUnit.Framework;

	[TestFixture]
	public class SingleSignOnServiceIntegrationTest : AbstractServiceIntegrationTest
	{
		#region Fields

		private static String relayState = "https://wwwintr2.ehealth.fgov.be/testsso";

		#endregion Fields

		#region Methods
		
		[Test]
		public void withSAML2Artifact()
		{
			ServiceFactory.getSingleSignOnService().signin(SsoProfile.SAML2_ARTIFACT, relayState);
		}

		[Test]
		public void withSAML2ArtifactWithoutRelayState()
		{
			ServiceFactory.getSingleSignOnService().signin(SsoProfile.SAML2_ARTIFACT);
		}
		
		[Test]
		public void withSAML2POST()
		{
			ServiceFactory.getSingleSignOnService().signin(SsoProfile.SAML2_POST, relayState);
		}
		
		[Test]
		public void withSAML2POSTWithoutRelayState()
		{
			ServiceFactory.getSingleSignOnService().signin(SsoProfile.SAML2_POST);
		}

		#endregion Methods
	}
}