﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.hubservices.core.v1;
using NUnit.Framework;
using org.joda.time;
using be.ehealth.businessconnector.hub.builders;
using be.ehealth.businessconnector.hub.exception;
using be.ehealth.businessconnector.hub.service;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

namespace be.ehealth.businessconnector.hub.session
{
	/**
	 * Integration test for {@link HubServiceComplete}
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class HubServiceCompleteIntegrationTest:AbstractIntrahubIntegrationTest
	{
		 private static String PATIENT_INSS = "82051234978";

	    private static HubServiceComplete hubServiceComplete;
	
	    [SetUp]
	    public static void initHubServiceCompleteIntegrationTest() {
	        hubServiceComplete = HubSessionServiceFactory.getHubServiceComplete();
	        initHub(AbstractIntrahubIntegrationTest.HUBID_RSW);
	    }
	    
	    /**
	     * @return
	     */
	    private AddressType createAddress() {
	        AddressType address = new AddressType();
	        address.setCity("");
	        CDADDRESS cdAddress = new CDADDRESS();
	        cdAddress.setS(CDADDRESSschemes.CD_ADDRESS);
	        cdAddress.setSV("1.0");
	        cdAddress.setValue("");
	        address.getCds().add(cdAddress);
	        CountryType country = new CountryType();
	        CDCOUNTRY cdCountry = new CDCOUNTRY();
	        cdCountry.setS(CDCOUNTRYschemes.CD_COUNTRY);
	        cdCountry.setSV("1.0");
	        cdCountry.setValue("");
	        country.setCd(cdCountry);
	        address.setCountry(country);
	        address.setDistrict("");
	        address.setHousenumber("");
	        address.setNis("");
	        address.setPostboxnumber("");
	        address.setStreet("");
	        address.setZip("");
	        return address;
	    }
	
	
	    /**
	     * @return
	     */
	    private AuthorType createAuthor() {
	        AuthorType author = new AuthorType();
	        be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = createHcpartyTypeComplete();
	        author.getHcparties().add(hcParty);
	        return author;
	    }
	
	
	    /**
	     * @return
	     */
	    private CDHCPARTY createCDHCPARTY() {
	        CDHCPARTY cdHcParty = new CDHCPARTY();
	        cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
	        cdHcParty.setSV("1.0");
	        cdHcParty.setValue(CDHCPARTYvalues.PERSPHYSICIAN.value());
	        return cdHcParty;
	    }
	
	
	    /**
	     * @return
	     */
	    private ConsentType createConsentType() {
	        ConsentType consent = new ConsentType();
	        consent.setAuthor(createAuthor());
	        consent.setPatient(createPatient());
	        consent.setRevokedate(new org.joda.time.DateTime());
	        consent.setSigndate(new org.joda.time.DateTime());
	        CDCONSENT cdConsent = new CDCONSENT();
	        cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
	        cdConsent.setSV("1.0");
	        cdConsent.setValue(CDCONSENTvalues.PROSPECTIVE);
	        consent.getCds().add(cdConsent);
	        return consent;
	    }
	
	
	    /**
	     * @return
	     */
	    private HCPartyIdType createHcParty() {
	        HCPartyIdType hcParty = new HCPartyIdType();
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        return hcParty;
	    }
	
	
	    /**
	     * @return
	     */
	    private HCPartyAdaptedType createHcPartyAdaptedType() {
	        HCPartyAdaptedType hcParty = new HCPartyAdaptedType();
	        hcParty.setFamilyname("De Clercq");
	        hcParty.setFirstname("Hannes");
	        CDHCPARTY cdHcParty = createCDHCPARTY();
	        hcParty.getCds().add(cdHcParty);
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        hcParty.setRecorddatetime(new org.joda.time.DateTime());
	        hcParty.getAddresses().add(createAddress());
	        hcParty.getTelecoms().add(createTelecom());
	        return hcParty;
	    }
	
	
	    /**
	     * @return
	     */
	    private be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType createHcpartyTypeComplete() {
	        be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
	        hcParty.setFamilyname("De Clercq");
	        hcParty.setFirstname("Hannes");
	        CDHCPARTY cdHcParty = createCDHCPARTY();
	        hcParty.getCds().add(cdHcParty);
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        return hcParty;
	    }
	
	
	    /**
	     * @return
	     */
	    private IDHCPARTY createIDHCPARTY() {
	        IDHCPARTY idHcparty = new IDHCPARTY();
	        idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
	        idHcparty.setSV("1.0");
	        idHcparty.setValue(PATIENT_INSS);
	        return idHcparty;
	    }
	
	
	    /**
	     * @return
	     */
	    private IDKMEHR createIdKmehr() {
	        IDKMEHR id = new IDKMEHR();
	        id.setS(IDKMEHRschemes.ID_KMEHR);
	        id.setSV("1.0");
	        id.setValue("45454");
	        return id;
	    }
	
	
	    /**
	     * @return
	     */
	    private IDPATIENT createIdPatient() {
	        IDPATIENT idPatient = new IDPATIENT();
	        idPatient.setS(IDPATIENTschemes.INSS);
	        idPatient.setSV("1.0");
	        idPatient.setValue(PATIENT_INSS);
	        return idPatient;
	    }
	    
        private PatientIdType createPatientIdType() {
	        // Patient for which to put therapeutic link
	        PatientIdType patient = new PatientIdType();
	        IDPATIENT kmehrPatientId = new IDPATIENT();
	        kmehrPatientId.setS(IDPATIENTschemes.INSS);
	        kmehrPatientId.setSV("1.0");
	        kmehrPatientId.setValue("82051234978");
	        patient.getIds().add(kmehrPatientId);
	        return patient;
	    }
	
        private PersonType createPatientForTransaction() {
	        // Patient for which to put therapeutic link
	        PersonType patient = new PersonType();
	        IDPATIENT kmehrPatientId = new IDPATIENT();
	        kmehrPatientId.setS(IDPATIENTschemes.INSS);
	        kmehrPatientId.setSV("1.0");
	        kmehrPatientId.setValue("82051234978");
	        patient.getIds().add(kmehrPatientId);
	        patient.getFirstnames().add("Hannes");
	        patient.setFamilyname("De Clercq");
	        return patient;
	    }
	
	    /**
	     * @return
	     */
	    private PatientIdType createPatient() {
	        PatientIdType patient = new PatientIdType();
	        IDPATIENT idPatient = createIdPatient();
	        patient.getIds().add(idPatient);
	        return patient;
	    }
	
	
	    /**
	     * @return
	     */
	    private TelecomType createTelecom() {
	        TelecomType telecom = new TelecomType();
	        telecom.setTelecomnumber("");
	        CDTELECOM cdTelecom = new CDTELECOM();
	        cdTelecom.setS(CDTELECOMschemes.CD_TELECOM);
	        cdTelecom.setSV("1.0");
	        cdTelecom.setValue("");
	        telecom.getCds().add(cdTelecom);
	        return telecom;
	    }
	
	
	    /**
	     * @return
	     */
	    private TherapeuticLinkType createTherapeuticLinkType() {
	        TherapeuticLinkType therapeuticLink = new TherapeuticLinkType();
	        CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
	        cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
	        cdTherLink.setSV("1.0");
	        cdTherLink.setValue("gpconsultation");
	        therapeuticLink.setCd(cdTherLink);
	        therapeuticLink.setComment("");
	        therapeuticLink.setEnddate(new org.joda.time.DateTime());
	        therapeuticLink.setHcparty(createHcParty());
	        therapeuticLink.setPatient(createPatient());
	        therapeuticLink.setStartdate(new org.joda.time.DateTime());
	        return therapeuticLink;
	    }
	
	
	    /**
	     * @return
	     */
	    private TransactionBaseType createTransaction() {
	        TransactionBaseType transaction = new TransactionBaseType();
	        AuthorType author = createAuthor();
	        transaction.setAuthor(author);
	        transaction.setId(createIdKmehr());
	        return transaction;
	    }
	    
        private HeaderType createHeader() {
	        HeaderType header = new HeaderType();
	
	        StandardType standard = new StandardType();
	        CDSTANDARD cd = new CDSTANDARD();
	        cd.setSV("1.4");
	        cd.setValue("20110701");
	        cd.setS("CD-STANDARD");
	        standard.setCd(cd);
	
	        header.setStandard(standard);
	        header.getIds().add(createMessageId(SessionUtil.getNihii11() + "." + IdGeneratorFactory.getIdGenerator().generateId()));
	        org.joda.time.DateTime now = new org.joda.time.DateTime();
	        header.setDate(now);
	        header.setTime(now);
	        header.getRecipients().add(createHub());
	        header.setSender(createSender());
	        return header;
	    }
	    
        private TransactionType createTransactionType() {
	    	MarshallerHelper helper = new MarshallerHelper(java.lang.Class.forName("be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType"),java.lang.Class.forName("be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType"));
	    	TransactionType transaction = (TransactionType) helper.toObject("<transaction xmlns='http://www.ehealth.fgov.be/standards/kmehr/schema/v1'><id S='ID-KMEHR' SV='1.0'>1</id><cd S='CD-TRANSACTION' SV='1.4'>sumehr</cd><date>2013-07-17</date><time>10:01:51+01:00</time><iscomplete>true</iscomplete><isvalidated>true</isvalidated><item><id S='ID-KMEHR' SV='1.0'>1</id><cd S='CD-ITEM' SV='1.4'>risk</cd><content><text L='fr'>travail sur écran</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:53:28+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>2</id><cd S='CD-ITEM' SV='1.4'>adr</cd><content><text L='fr'>Ticlopidine</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:52:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>3</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>B01AC05</cd></content><content><text L='fr'>Ticlid (c) 250mg - 30 compr. enrobé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>0857995</intendedcd><intendedname>Ticlid (c) 250mg - 30 compr. enrobé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>chronic</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. enrobé(s) 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>4</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>C10AA07</cd></content><content><text L='fr'>rosuvastatine 40 mg - 98 compr. pelliculé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2055176</intendedcd><intendedname>rosuvastatine 40 mg - 98 compr. pelliculé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><endmoment><date>2013-09-27</date></endmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>acute</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>5</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-ATC' SV='1.0'>J07AM51</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>1077593</intendedcd><intendedname>Tedivax pro adulto (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>6</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>pertussis</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>poliomyelitis</cd><cd S='CD-ATC' SV='1.0'>J07CA02</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2374429</intendedcd><intendedname>Boostrix Polio (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item></transaction>");
	
	        AuthorType author = new AuthorType();
	        author.getHcparties().addAll(createSender().getHcparties());
	
	        transaction.setAuthor(author);
	        transaction.getIds().add(createMessageId("1"));
	        transaction.getIds().add(CreateTransactionId("2"));
	        return transaction;
	    }
	    
        private TransactionBaseType createTransactionBaseType() {
	        TransactionBaseType transaction = new TransactionBaseType();
	        
	        AuthorType author = new AuthorType();
	        author.getHcparties().addAll(createSender().getHcparties());
	        transaction.setAuthor(author);
	        transaction.setId(CreateTransactionId("2"));
	        return transaction;
	    }
	    
	       private IDKMEHR CreateTransactionId(String version) {
        IDKMEHR id = new IDKMEHR();

        id.setS(IDKMEHRschemes.LOCAL);
        id.setSL("EHBASICSOFT");
        id.setSV("3.4.0-SNAPSHOT");
        id.setValue(version);
        return id;
    }

    private IDKMEHR createMessageId(String value){
        // add the ID to the message (see top of method for structure)
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.ID_KMEHR);
        id.setSV("1.0");
        id.setValue(value);

        return id;
    }

    private SenderType createSender() {
        be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();

        IDHCPARTY doctorNISS = new IDHCPARTY();
        IDHCPARTY doctorNIHII = new IDHCPARTY();
        CDHCPARTY hcPartytype = new CDHCPARTY();

        doctorNIHII.setS(IDHCPARTYschemes.ID_HCPARTY);
        doctorNIHII.setSV("1.0");
        doctorNIHII.setValue("10013368003");

        doctorNISS.setS(IDHCPARTYschemes.INSS);
        doctorNISS.setSV("1.0");
        doctorNISS.setValue("82051234978");

        hcPartytype.setS(CDHCPARTYschemes.CD_HCPARTY);
        hcPartytype.setSV("1.1");
        hcPartytype.setValue(CDHCPARTYvalues.PERSPHYSICIAN.value());

        java.util.List idList = new java.util.ArrayList();
        idList.add(doctorNIHII);
        idList.add(doctorNISS);

        java.util.List cdList = new java.util.ArrayList();
        cdList.add(hcPartytype);

        hcParty.getIds().addAll(idList);
        hcParty.getCds().addAll(cdList);

        hcParty.setFamilyname("De Clercq");
        hcParty.setFirstname("Hannes");

        SenderType sender = new SenderType();
        sender.getHcparties().add(hcParty);

        return sender;
    }

    private RecipientType createHub() {
        be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hub = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
        IDHCPARTY id = new IDHCPARTY();
        id.setValue("1990000035");
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        hub.getIds().add(id);
        CDHCPARTY cd = new CDHCPARTY();
        cd.setValue("hub");
        cd.setSV("1.3");
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        hub.getCds().add(cd);
        hub.setName("RSW");
        RecipientType rec = new RecipientType();
        rec.getHcparties().add(hub);
        return rec;
    }
	
	
	    /**
	     * @return
	     */
	    private TransactionIdType createTransactionIdType() {
	        TransactionIdType transaction = new TransactionIdType();
	        transaction.getIds().add(createIdKmehr());
	        return transaction;
	    }
	
	
	    /**
	     * @return
	     */
	    private TransactionWithPeriodType createTransactionWithPeriodType() {
	        TransactionWithPeriodType transaction = new TransactionWithPeriodType();
	        transaction.setAuthor(createAuthor());
	        transaction.setBegindate(new org.joda.time.DateTime());
	        transaction.setEnddate(new org.joda.time.DateTime());
	        return transaction;
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    [ExpectedException(typeof(KmehrBusinessConnectorException))]
	    public void declareTransactionComplete() {
	        KmehrHeaderDeclareTransaction kmehrHeader = new KmehrHeaderDeclareTransaction();
	        be.fgov.ehealth.hubservices.core.v1.FolderType folder = new be.fgov.ehealth.hubservices.core.v1.FolderType();
	        PatientIdType patient = createPatient();
	
	        TransactionSummaryType transaction = new TransactionSummaryType();
	        AuthorType author = createAuthor();
	        transaction.setAuthor(author);
	        CDTRANSACTION cdTransaction = new CDTRANSACTION();
	        cdTransaction.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
	        cdTransaction.setSV("1.0");
	        cdTransaction.setValue("sumehr");
	        transaction.getCds().add(cdTransaction);
	        transaction.setDate(new org.joda.time.DateTime());
	        transaction.getIds().add(createIdKmehr());
	        transaction.setIscomplete(true);
	        transaction.setIsvalidated(true);
	        transaction.setTime(new org.joda.time.DateTime());
	        transaction.setRecorddatetime(new org.joda.time.DateTime());
	
	        folder.setTransaction(transaction);
	        folder.setPatient(patient);
	        kmehrHeader.setFolder(folder);
	        hubServiceComplete.declareTransaction(kmehrHeader);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getAccessRight() {
	        TransactionIdType transaction = new TransactionIdType();
	        IDKMEHR id = createIdKmehr();
	        transaction.getIds().add(id);
	        hubServiceComplete.getAccessRight(transaction);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getHcParty() {
	        HCPartyIdType hcParty = createHcParty();
	        hubServiceComplete.getHCParty(hcParty);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getHcPartyConsentComplete() {
	        HCPartyIdType hcParty = createHcParty();
	        hubServiceComplete.getHCPartyConsent(hcParty);
	    }
	
	    /**
	     * 
	     */
	    [Test]
	    public void getPatient() {
	        hubServiceComplete.getPatient(createPatient());
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getPatientAudiTrail() {
	        SelectGetPatientAuditTrailType patientAudiTrail = new SelectGetPatientAuditTrailType();
	        patientAudiTrail.setBegindate(new org.joda.time.DateTime());
	        patientAudiTrail.setEnddate(new org.joda.time.DateTime());
	        patientAudiTrail.setHcparty(createHcParty());
	        patientAudiTrail.setPatient(createPatient());
	        patientAudiTrail.setSearchtype(LocalSearchType.LOCAL);
	        patientAudiTrail.setTransaction(createTransaction());
	        hubServiceComplete.getPatientAuditTrail(patientAudiTrail);
	    }
	
	
	    /**
	     * @throws ConnectorException
	     * @throws TechnicalConnectorException
	     * @throws IntraHubBusinessConnectorException
	     */
	    [Test]
	    public void getPatientConsentComplete() {
	        SelectGetPatientConsentType patientConsent = new SelectGetPatientConsentType();
	        Consent consent = new Consent();
	        CDCONSENT cdConsent = new CDCONSENT();
	        cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
	        cdConsent.setSV("1.0");
	        cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
	        consent.getCds().add(cdConsent);
	        patientConsent.setConsent(consent);
	        PatientIdType patient = createPatient();
	        patientConsent.setPatient(patient);
	        hubServiceComplete.getPatientConsent(patientConsent);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getTherapeuticLinkComplete() {
	        SelectGetHCPartyPatientConsentType consent = new SelectGetHCPartyPatientConsentType();
	        consent.setBegindate(new org.joda.time.DateTime());
	        consent.setEnddate(new org.joda.time.DateTime());
	        CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
	        cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
	        cdTherLink.setSV("1.0");
	        cdTherLink.setValue("gpconsultation");
	        consent.getCds().add(cdTherLink);
	        consent.getPatientsAndHcparties().add(createHcParty());
	        consent.getPatientsAndHcparties().add(createPatient());
	        hubServiceComplete.getTherapeuticLink(consent);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void getTransaction() {
	        hubServiceComplete.getTransaction(createPatient(), createTransactionBaseType());
	    }
	
	
	    [Test]
	    public void getTransactionList() {
	        TransactionWithPeriodType transaction = createTransactionWithPeriodType();
	        hubServiceComplete.getTransactionList(createPatient(), LocalSearchType.LOCAL, transaction);
	
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putAccessRight() {
	        AccessRightType accessRight = new AccessRightType();
	        CDACCESSRIGHT cdAccessRight = new CDACCESSRIGHT();
	        cdAccessRight.setS(CDACCESSRIGHTschemes.CD_ACCESSRIGHT);
	        cdAccessRight.setSV("1.0");
	        cdAccessRight.setValue(CDACCESSRIGHTvalues.ALLOW);
	        accessRight.setCd(cdAccessRight);
	        be.fgov.ehealth.hubservices.core.v1.HcpartyType hcParty = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
	        hcParty.getCds().add(createCDHCPARTY());
	        hcParty.getIds().add(createIDHCPARTY());
	        accessRight.setHcparty(hcParty);
	        TransactionIdType transaction = createTransactionIdType();
	        accessRight.setTransaction(transaction);
	        hubServiceComplete.putAccessRight(accessRight);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putHcPartyComplete() {
	        hubServiceComplete.putHCParty(createHcPartyAdaptedType());
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putHcPartyConsentComplete() {
	        ConsentHCPartyType consent = new ConsentHCPartyType();
	        consent.setAuthor(createAuthor());
	        consent.setHcparty(createHcParty());
	        consent.setRevokedate(new org.joda.time.DateTime());
	        consent.setSigndate(new org.joda.time.DateTime());
	        hubServiceComplete.putHCPartyConsent(consent);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putPatientComplete() {
	        PersonType person = new PersonType();
	        person.getFirstnames().add("Hannes");
	        DateType dateType = new DateType();
	        dateType.setDate(new org.joda.time.DateTime());
	        dateType.setTime(new org.joda.time.DateTime());
	        person.setBirthdate(dateType);
	        AddressTypeBase address = new AddressTypeBase();
	        address.setCity("");
	        CountryType country = new CountryType();
	        CDCOUNTRY cdCountry = new CDCOUNTRY();
	        cdCountry.setS(CDCOUNTRYschemes.CD_COUNTRY);
	        cdCountry.setSV("1.0");
	        cdCountry.setValue("");
	        country.setCd(cdCountry);
	        address.setCountry(country);
	        address.setDistrict("");
	        address.setHousenumber("");
	        address.setNis("");
	        address.setPostboxnumber("");
	        address.setStreet("");
	        address.setZip("");
	        CDADDRESS cdAddress = new CDADDRESS();
	        cdAddress.setS(CDADDRESSschemes.CD_ADDRESS);
	        cdAddress.setSV("1.0");
	        cdAddress.setValue("");
	        address.getCds().add(cdAddress);
	        person.setBirthlocation(address);
	        person.setDeathdate(null);
	        person.setDeathlocation(null);
	        person.setFamilyname("De Clercq");
	        MemberinsuranceType memberInsuranceType = new MemberinsuranceType();
	        IDINSURANCE idInsurance = new IDINSURANCE();
	        idInsurance.setS(IDINSURANCEschemes.ID_INSURANCE);
	        idInsurance.setSV("1.0");
	        idInsurance.setValue("00");
	        memberInsuranceType.setId(idInsurance);
	        memberInsuranceType.setMembership(null);
	        person.setInsurancymembership(null);
	        InsuranceType insuranceType = new InsuranceType();
	        insuranceType.setApprovalnumber("");
	        insuranceType.setBegindate(new org.joda.time.DateTime());
	        insuranceType.setBegindatepayment(new org.joda.time.DateTime());
	        insuranceType.setCg1("ss");
	        insuranceType.setCg2("ss");
	        insuranceType.setEnddate(new org.joda.time.DateTime());
	        insuranceType.setId(idInsurance);
	        insuranceType.setMembership("ss");
	        insuranceType.setSiscard("ss");
	        insuranceType.setSocialfranchiseperiod1("ss");
	        insuranceType.setSocialfranchiseperiod2("ss");
	        insuranceType.setThirdpayercontract(null);
	        person.setInsurancystatus(insuranceType);
	        Nationality nationality = new Nationality();
	        nationality.setCd(cdCountry);
	        person.setNationality(nationality);
	        person.setProfession(null);
	        person.setRecorddatetime(new org.joda.time.DateTime());
	        person.setUsuallanguage("ss");
	        SexType sex = new SexType();
	        CDSEX cdSex = new CDSEX();
	        cdSex.setS("CD-SEX");
	        cdSex.setSV("1.0");
	        cdSex.setValue(CDSEXvalues.FEMALE);
	        sex.setCd(cdSex);
	        person.setSex(sex);
	        person.getIds().add(createIdPatient());
	        hubServiceComplete.putPatient(person);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putPatientConsentComplete() {
	        ConsentType consent = createConsentType();
	        hubServiceComplete.putPatientConsent(consent);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putTherapeuticLinkComplete() {
	        TherapeuticLinkType therapeuticLink = createTherapeuticLinkType();
	        hubServiceComplete.putTherapeuticLink(therapeuticLink);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void putTransactionComplete() {
	        Kmehrmessage transactionToPut = new Kmehrmessage();
	        transactionToPut.setHeader(createHeader());
	
	        be.fgov.ehealth.standards.kmehr.schema.v1.FolderType folder = new be.fgov.ehealth.standards.kmehr.schema.v1.FolderType();
	        folder.getIds().add(createMessageId("1"));
	        folder.setPatient(createPatientForTransaction());
	        folder.getTransactions().add(createTransactionType());
	
	        transactionToPut.getFolders().add(folder);
	        hubServiceComplete.putTransaction(transactionToPut);
	    }
	
	
	    /**
	     * 
	     */
	
	    [Test]
	    public void requestPublication() {
	        hubServiceComplete.requestPublication(createPatient(), createTransactionWithPeriodType(), "");
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void revokeAccessRight() {
	        SelectRevokeAccessRightType accessRight = new SelectRevokeAccessRightType();
	        be.fgov.ehealth.hubservices.core.v1.HcpartyType hcParty = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
	        hcParty.getCds().add(createCDHCPARTY());
	        hcParty.getIds().add(createIDHCPARTY());
	        accessRight.setHcparty(hcParty);
	        accessRight.setTransaction(createTransactionIdType());
	        hubServiceComplete.revokeAccessRight(accessRight);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void revokeHcPartyConsent() {
	        ConsentHCPartyType consent = new ConsentHCPartyType();
	        consent.setAuthor(createAuthor());
	        consent.setHcparty(createHcParty());
	        consent.setRevokedate(new org.joda.time.DateTime());
	        consent.setSigndate(new org.joda.time.DateTime());
	        hubServiceComplete.revokeHCPartyConsent(consent);
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void revokePatientConsentComplete() {
	        hubServiceComplete.revokePatientConsent(createConsentType());
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void revokeTherapeuticLinkComplete() {
	        hubServiceComplete.revokeTherapeuticLink(createTherapeuticLinkType());
	    }
	
	
	    /**
	     * 
	     */
	    [Test]
	    public void revokeTransaction() {
	        TransactionIdType transid = new TransactionIdType();
	        transid.getIds().add(CreateTransactionId("1"));
	        hubServiceComplete.revokeTransaction(createPatientIdType(), transid);
	    }
	}
}
