﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using java.lang;
using NUnit.Framework;
using java.util;
using org.joda.time;
using be.ehealth.businessconnector.hub.builders;
using be.ehealth.businessconnector.hub.service.impl;
using be.ehealth.businessconnector.hub.session;
using be.ehealth.businessconnector.hub.validators.impl;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.hubservices.core.v1;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.technicalconnector.config.impl;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.hub.service
{
	/**
	 * Tests services methods and saves the result in a file
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class AbstractIntrahubIntegrationTest 
	{
	    /**
	     * Hub ID value for RSW hub
	     */
	    protected static string HUBID_RSW = "1990000035";
	    /**
	     * Hub ID value for VZNKUL hub
	     */
	    protected static string HUBID_VZNKUL = "1990000827";
	    /**
	     * Hub ID value for COZO hub
	     */
	    protected static string HUBID_COZO = "1990000134";
	
	    /**
	     * Hub ID value for ARH hub
	     */
	    protected static string HUBID_ARH = "1990000233";
	
	    /**
	     * URL to contact for RSW hub
	     */
	    private static string URL_RSW = "https://hub.reseausantewallon.be/standards/hubservices/intrahub/intrahubservice.asmx";
	
	    /**
	     * URL to contact for VZNKUL hub
	     */
	    private static string URL_VZNKUL = "https://hubacc.vznkul.be/services/acceptance/intrahub/IntraHubService";
	
	    /**
	     * URL to contact for COZO hub
	     */
	    private static string URL_COZO = "https://www.gzo.be/IntrahubServiceTest/service.asmx";
	
	    /**
	     * URL to contact for ARH hub
	     */
	    private static string URL_ARH = "https://test.antwerpseregionalehub.be/IntrahubService/service.asmx?wsdl";
	
	    private static Configuration technicalConfig;
	    
	    private static Properties props;

	
	    /**
	     * Properties keys
	     */
	    protected static string HUB_ID = "hub.id";
	
	    protected static string ENDPOINT_HUB_INTRA = "endpoint.hub.intra";
	
	    protected static string TEST_HUB_TESTCASE_REPORTTYPE = "test.hub.testcase.reporttype";
	
	    protected static string TEST_HUB_TESTCASE_PATIENT_INSS = "test.hub.testcase.patient.inss";
	
	    protected static string TEST_HUB_TESTCASE_TRANSACTION_VALUE = "test.hub.testcase.transaction.value";
	
	    protected static string TEST_HUB_TESTCASE_TRANSACTION_SL = "test.hub.testcase.transaction.sl";
	
	    protected static string TEST_HUB_TESTCASE_HCPARTY_INSS = "test.hub.testcase.hcparty.inss";
	
	    protected static string TEST_HUB_TESTCASE_HCPARTY_ID = "test.hub.testcase.hcparty.id";
	
	    protected static Configuration techConfig;
	    
	    protected static java.util.List requiredProperties = new ArrayList();
	    
	    [SetUp]
	    public void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.intrahub.test.properties", SupportedLanguages.NET.getAbbreviation());
	    	technicalConfig = ConfigFactory.getConfigValidator().getConfig();
	    	props = TestPropertiesLoader.getProperties(".\\be.ehealth.businessconnector.intrahub.test.properties");
	    	new ConfigurationModuleProxy().init(technicalConfig);
	    }
	    
	    [TearDown]
	    public void tearDownIntrahubSession() {
	    	Session.getInstance().unloadSession();
	    }
	    
	    /**
	     * Initialise properties with VZNKUL hub values
	     */
	    protected static void initHub(string hubid) {
	    	if (HUBID_RSW.equalsIgnoreCase(hubid)) {
    	    	technicalConfig.setProperty(ENDPOINT_HUB_INTRA, URL_RSW);
    	    	props.setProperty(HUB_ID, HUBID_RSW);
    	    }
	    	else if(HUBID_VZNKUL.equalsIgnoreCase(hubid)) {
	    		technicalConfig.setProperty(ENDPOINT_HUB_INTRA, URL_VZNKUL);
	    		props.setProperty(HUB_ID, HUBID_VZNKUL);
	    	}
	    	else if (HUBID_COZO.equalsIgnoreCase(hubid)) {
	    		technicalConfig.setProperty(ENDPOINT_HUB_INTRA, URL_COZO);
	    		props.setProperty(HUB_ID, HUBID_COZO);
	    	}
	    	else if (HUBID_ARH.equalsIgnoreCase(hubid)) {
	    		technicalConfig.setProperty(ENDPOINT_HUB_INTRA, URL_ARH);
	    		props.setProperty(HUB_ID, HUBID_ARH);
	    	}
	    }
	    
	}
}
