/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.builders.impl;

import static org.junit.Assert.assertEquals;

import java.util.Date;
import java.util.List;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.kmehrcommons.HcPartyUtil;
import be.ehealth.businessconnector.therlink.builders.CommonObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.ProofBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.therlink.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.TherapeuticLink;
import be.ehealth.businessconnector.therlink.domain.requests.PutTherapeuticLinkRequest;
import be.ehealth.businessconnector.therlink.util.ConfigReader;
import be.ehealth.businessconnector.therlink.util.TherapeuticLinkTypeValues;
import be.ehealth.businessconnector.therlink.util.TherlinkTestUtils;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Integration test for {@link GPRequestObjectBuilderImpl}
 * 
 * @author EHP
 * 
 */
public class RequestBuilderIntegrationTest {

    private static String linkType;

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.therlink.test.properties", false);
        linkType = TherapeuticLinkTypeValues.valueOf(ConfigFactory.getConfigValidator().getProperty("main.kmehr.quality").toUpperCase()).getTherlinkType();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    @SuppressWarnings("deprecation")
    public void createPutTherapeuticLinkRequestGPDefaultValues() throws Exception {
        CommonObjectBuilder commonBuilder = RequestObjectBuilderFactory.getCommonBuilder();
        ProofBuilder proofBuilder = RequestObjectBuilderFactory.getProofBuilder();
        RequestObjectBuilder requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();

        Patient patientMapped = TherlinkTestUtils.getOfflinePatient();
        Date startDate = new Date();
        List<HcParty> authorHcParties = requestObjectBuilder.getAuthorHcParties();

        TherapeuticLink createTherapeuticLink = commonBuilder.createTherapeuticLink(patientMapped, HcPartyUtil.getAuthorKmehrQuality(), linkType, startDate, new DateTime().plusMonths(6).toDate(), null, ConfigReader.getCareProvider());

        PutTherapeuticLinkRequest request = new PutTherapeuticLinkRequest(commonBuilder.createKmehrID(), startDate, commonBuilder.createAuthor(authorHcParties), createTherapeuticLink, proofBuilder.createProofForEidReading());

        Assert.assertNotNull(request);
        HcParty hcp = ConfigReader.getCareProvider();

        assertEquals(patientMapped, request.getLink().getPatient());
        final HcParty hcParty = request.getLink().getHcParty();
        Assert.assertEquals(hcp.getIds().size(), hcParty.getIds().size());
        Assert.assertEquals(hcp.getFirstName(), hcParty.getFirstName());
        Assert.assertEquals(hcp.getFamilyName(), hcParty.getFamilyName());
        assertEquals(linkType, request.getLink().getType());
    }
}
