/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.service;

import java.io.InputStream;

import org.junit.Assert;
import org.junit.Test;


/**
 * This testclass the ServiceFactory
 * 
 * @author EHP
 * 
 */
public class ServiceFactoryTest {

    /**
     * Test if all the xsd needed by the ServiceFactory are present on the classpath.
     * 
     * @throws Exception
     */
    @Test
    public void testXSDPresent() throws Exception {
        for (String xsd : ServiceFactory.INTRAHUB_XSD) {
            InputStream in = ServiceFactoryTest.class.getResourceAsStream(xsd);
            Assert.assertNotNull(in);
        }
    }
}
