/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.service;

import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.ehealth.businessconnector.therlink.service.TherLinkService;
import be.ehealth.businessconnector.therlink.service.impl.TherLinkServiceImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static final String THERLINK_PROTOCOL = "/ehealth-hubservices/XSD/hubservices_protocol-2_1.xsd";
    private static final String PROP_ENDPOINT_THERLINK = "endpoint.therlink";
    private static final String PROP_VALIDATION_INCOMING_THERLINK = "validation.incoming.therlink.message";
    private static List<String> expectedProps = new ArrayList<String>();
    private static Configuration config;
    static final String[] THERLINK_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getTherLinkPort(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, TherLinkBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_THERLINK));
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.setDefaultHandlerChain();
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_THERLINK))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, THERLINK_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, THERLINK_XSD));
        }
        genReq.setHandlerChain(chain);
        return genReq;
    }

    public static TherLinkService getTherLinkService() {
        return new TherLinkServiceImpl();
    }

    static {
        THERLINK_XSD = new String[]{THERLINK_PROTOCOL};
        expectedProps.add(PROP_ENDPOINT_THERLINK);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

