/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.validator;

import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.Identification;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Origin;
import be.ehealth.business.mycarenetcommons.domain.Party;
import be.ehealth.business.mycarenetcommons.exception.ConnectorValidationException;
import be.ehealth.business.mycarenetcommons.exception.ValidationError;
import be.ehealth.business.mycarenetcommons.validator.AbstractMyCarenetValidator;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import java.util.ArrayList;
import java.util.List;

public class CommonInputValidator
extends AbstractMyCarenetValidator {
    public static void validate(CommonInput commonInput) throws ConnectorValidationException {
        String currentPath = "commonInput";
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        CommonInputValidator.validateIsTest(errors, CommonInputValidator.addPath(currentPath, "isTest"), commonInput.isTest());
        CommonInputValidator.validateOrigin(errors, CommonInputValidator.addPath(currentPath, "Origin"), commonInput.getOrigin());
        CommonInputValidator.validateInputReference(errors, CommonInputValidator.addPath(currentPath, "InputReference"), commonInput.getInputReference());
        if (!errors.isEmpty()) {
            throw new ConnectorValidationException(errors);
        }
    }

    private static void validateInputReference(List<ValidationError> errors, String path, String inputReference) {
        if (inputReference == null) {
            errors.add(new ValidationError(path, "the inputReference is null"));
        }
    }

    private static void validateOrigin(List<ValidationError> errors, String path, Origin origin) {
        if (origin == null) {
            errors.add(new ValidationError(path, "Origin was null"));
        } else {
            if (origin.getCareProvider() == null && origin.getSender() == null) {
                errors.add(new ValidationError(path, "at least one of careProvider or Sender must be filled out"));
            }
            CommonInputValidator.validateCareProvider(errors, CommonInputValidator.addPath(path, "CareProvider"), origin.getCareProvider());
            CommonInputValidator.validatePackageInfo(errors, CommonInputValidator.addPath(path, "PackageInfo"), origin.getPackageInfo());
            CommonInputValidator.validateSender(errors, CommonInputValidator.addPath(path, "Sender"), origin.getSender());
        }
    }

    private static void validateSender(List<ValidationError> errors, String path, Party sender) {
        if (sender != null) {
            CommonInputValidator.validatePartyType(errors, path, sender);
        }
    }

    private static void validatePartyType(List<ValidationError> errors, String path, Party party) {
        if (party == null) {
            errors.add(new ValidationError(path, "required party was null"));
        } else {
            Identification organization = party.getOrganization();
            Identification physicalPerson = party.getPhysicalPerson();
            if (organization == null && physicalPerson == null) {
                errors.add(new ValidationError(path, "party without organisation and physicalPerson , at least one of them must be filled out"));
            }
            CommonInputValidator.validateIdentificationIfNotNull(errors, CommonInputValidator.addPath(path, "organisation"), organization);
            CommonInputValidator.validateIdentificationIfNotNull(errors, CommonInputValidator.addPath(path, "physicalPerson"), physicalPerson);
        }
    }

    private static void validateIdentificationIfNotNull(List<ValidationError> errors, String path, Identification organization) {
        if (organization != null) {
            CommonInputValidator.validateIdentification(errors, path, organization);
        }
    }

    private static void validateIdentification(List<ValidationError> errors, String path, Identification identification) {
        if (identification == null) {
            errors.add(new ValidationError(path, "required identification is null"));
        } else {
            if (identification.getName() == null) {
                errors.add(new ValidationError(path, "the name if the identification is null, its a required parameter!"));
            }
            if (identification.getCbe() == null && identification.getNihii() == null && identification.getSsin() == null) {
                errors.add(new ValidationError(path, "no parameters are filled out in identification , at least a Cbe, nihii, or ssin is required!"));
            }
        }
    }

    private static void validatePackageInfo(List<ValidationError> errors, String path, PackageInfo packageInfo) {
        if (packageInfo == null) {
            errors.add(new ValidationError(path, "packageInfo is required, but was null"));
        } else {
            if (packageInfo.getPassword() == null) {
                errors.add(new ValidationError(path, "packageInfo.password was null"));
            }
            if (packageInfo.getUserName() == null) {
                errors.add(new ValidationError(path, "packageInfo.userName was null"));
            }
        }
    }

    private static void validateCareProvider(List<ValidationError> errors, String path, CareProvider careProvider) {
        if (careProvider != null) {
            CommonInputValidator.validateNihii(errors, CommonInputValidator.addPath(path, "Nihii"), careProvider.getNihii());
            if (careProvider.getOrganization() != null) {
                CommonInputValidator.validateIdentification(errors, CommonInputValidator.addPath(path, "Organisation"), careProvider.getOrganization());
            }
            if (careProvider.getPhysicalPerson() != null) {
                CommonInputValidator.validateIdentification(errors, CommonInputValidator.addPath(path, "PhysicalPerson"), careProvider.getPhysicalPerson());
            }
        }
    }

    private static void validateNihii(List<ValidationError> errors, String path, Nihii nihii) {
        if (nihii == null) {
            errors.add(new ValidationError(path, "Nihii was null"));
        } else {
            if (nihii.getQuality() == null) {
                errors.add(new ValidationError(path, "nihii.quality was null"));
            }
            if (nihii.getValue() == null) {
                errors.add(new ValidationError(path, "nihii.value was null"));
            }
        }
    }

    private static void validateIsTest(List<ValidationError> errors, String path, Boolean test) {
        if (test == null) {
            errors.add(new ValidationError(path, "the isTest variable should never be null"));
        }
    }
}

