/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import be.ehealth.business.mycarenetcommons.builders.impl.AbstractCommonBuilderImpl;
import be.ehealth.business.mycarenetcommons.builders.util.CareProviderBuilder;
import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.util.ArrayList;
import java.util.Map;

public class GenericCommonBuilderImpl
extends AbstractCommonBuilderImpl {
    private static final String VALUE = ".value";
    private static final String QUALITY = ".quality";
    private static final String PHYSICALPERSON = ".physicalperson";
    private static final String CAREPROVIDER = ".careprovider";
    private ConfigValidator config;
    private String projectName;

    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        if (parameterMap == null || parameterMap.isEmpty() || !parameterMap.containsKey("projectName")) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, new Object[]{"missing config parameters for initialize of CommonBuilder , check factory method call"});
        }
        this.projectName = (String)parameterMap.get("projectName");
        ArrayList<String> expectedProperties = new ArrayList<String>();
        String careProviderIdKey = "mycarenet." + this.projectName + CAREPROVIDER + ".nihii" + VALUE;
        String careProviderQualityKey = "mycarenet." + this.projectName + CAREPROVIDER + ".nihii" + QUALITY;
        expectedProperties.add(careProviderIdKey);
        expectedProperties.add(careProviderQualityKey);
        this.config = ConfigFactory.getConfigValidator(expectedProperties);
    }

    @Override
    protected CareProvider createCareProviderForOrigin() throws NumberFormatException, TechnicalConnectorException {
        String careProviderIdKey = "mycarenet." + this.projectName + CAREPROVIDER + ".nihii" + VALUE;
        String careProviderQualityKey = "mycarenet." + this.projectName + CAREPROVIDER + ".nihii" + QUALITY;
        CareProviderBuilder builder = new CareProviderBuilder(this.config.getProperty(careProviderQualityKey), this.config.getProperty(careProviderIdKey));
        String physicalPersonRootKey = "mycarenet." + this.projectName + CAREPROVIDER + PHYSICALPERSON;
        String organizationRootKey = "mycarenet." + this.projectName + CAREPROVIDER + ".organization";
        builder.addPhysicalPersonIdentification(this.createPerson(physicalPersonRootKey));
        builder.addOrganisationIdentification(this.createOrganization(organizationRootKey));
        return builder.build();
    }
}

