/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.util;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String PACKAGE_LICENCE_USERNAME = "package.licence.username";
    private static final String PACKAGE_LICENCE_PASSWORD = "package.licence.password";
    private static final String PACKAGE_LICENCE_NAME = "package.name";
    public static final String USE_DEFAULT_PROPERTIES = ".usedefaultproperties";
    public static final String DEFAULT = "default";

    private ConfigUtil() {
    }

    public static PackageInfo retrievePackageInfo(String componentName) throws TechnicalConnectorException {
        ArrayList<String> props = new ArrayList<String>();
        props.add(componentName + "." + PACKAGE_LICENCE_USERNAME);
        props.add(componentName + "." + PACKAGE_LICENCE_PASSWORD);
        props.add(componentName + "." + PACKAGE_LICENCE_NAME);
        ConfigValidator configValidator = ConfigFactory.getConfigValidator(props);
        if (configValidator.getUnfoundPropertiesAfterValidation() != null && configValidator.getUnfoundPropertiesAfterValidation().size() > 0) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.PROPERTY_MISSING, configValidator.getUnfoundPropertiesAfterValidation());
        }
        String userName = configValidator.getProperty(componentName + "." + PACKAGE_LICENCE_USERNAME);
        String password = configValidator.getProperty(componentName + "." + PACKAGE_LICENCE_PASSWORD);
        String name = configValidator.getProperty(componentName + "." + PACKAGE_LICENCE_NAME);
        return new PackageInfo(userName, password, name);
    }

    public static boolean retrieveBooleanProjectProperty(String prefix, String projectName, String suffix, boolean defaultValue) {
        ConfigValidator props = ConfigFactory.getConfigValidator();
        boolean result = props.getBooleanProperty(prefix + projectName + USE_DEFAULT_PROPERTIES, true) != false ? props.getBooleanProperty(prefix + DEFAULT + suffix, defaultValue).booleanValue() : props.getBooleanProperty(prefix + projectName + suffix, defaultValue).booleanValue();
        LOG.debug("retrieveBooleanProjectProperty for " + prefix + "." + projectName + "." + suffix + " : returning " + result);
        return result;
    }

    public static boolean isNet() throws TechnicalConnectorException {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            if (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                String path = url.getPath().toLowerCase();
                return StringUtils.contains((String)path, (String)"ikvm");
            }
            return false;
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }
}

