/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleClassloader;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleLogging;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleProperties;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleTrustStore;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleVersion;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationImpl
implements Configuration {
    public static final String SYSPROP_MODULE_LOADING = "be.ehealth.technicalconnector.config.modules.load";
    private static final String CONNECTOR_CONFIGMODULES = "connector.configmodule";
    private static final String DURATION = ".duration";
    private static final String TIMEUNIT = ".timeunit";
    private static volatile ConfigurationImpl instance;
    private static final String END_REF = "}";
    private static final String START_REF = "${";
    private static final String UDDI_REF = "$uddi{";
    private static final Logger LOG;
    private Properties properties;
    private Properties uddi;
    private String usedLocation;
    private static List<ConfigurationModule> cachedModules;

    private ConfigurationImpl() {
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getPropertyFromConfig(key, defaultValue);
    }

    @Override
    public Long getLongProperty(String key, Long defaultValue) {
        return Long.valueOf(this.getPropertyFromConfig(key, "" + defaultValue));
    }

    @Override
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        return Integer.valueOf(this.getPropertyFromConfig(key, "" + defaultValue));
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        return Boolean.valueOf(this.getPropertyFromConfig(key, "" + defaultValue));
    }

    @Override
    public Duration getDurationProperty(String key, Long defaultValue, TimeUnit defaultTimeUnit) {
        long duration = this.getLongProperty(key + DURATION, defaultValue);
        String timeUnit = this.getProperty(key + TIMEUNIT, defaultTimeUnit.name());
        return new Duration(duration, TimeUnit.valueOf(timeUnit));
    }

    @Override
    public boolean hasDurationProperty(String key) {
        return this.hasProperty(key + DURATION) && this.hasProperty(key + TIMEUNIT);
    }

    @Override
    public URL getURLProperty(String key) {
        String wsdl = this.getProperty(key);
        URL url = null;
        try {
            url = new URL(wsdl);
        }
        catch (MalformedURLException e) {
            LOG.error("No valid url: " + wsdl);
        }
        return url;
    }

    @Override
    public String getProperty(String key) {
        return this.getPropertyFromConfig(key, null);
    }

    private String getPropertyFromConfig(String key, String defaultValue) {
        return this.getPropertyRecursively(key, defaultValue, new ArrayList<String>());
    }

    private String getPropertyRecursively(String key, String defaultValue, List<String> propertyChain) {
        this.init();
        if (key == null || !this.properties.containsKey(key)) {
            LOG.debug("Using [" + defaultValue + "] for undefined property with key [" + key + "]");
            return this.lookup(propertyChain, defaultValue);
        }
        String value = null;
        if (propertyChain.contains(key)) {
            LOG.error("configuration error : while cascading through property references a loop was detected :  " + key + " references (indirectly) itself");
            throw new ConfigurationException("A circular reference detected for" + key);
        }
        propertyChain.add(key);
        value = this.properties.getProperty(key, defaultValue);
        value = this.lookup(propertyChain, value);
        LOG.debug("Returning value [" + value + "] for property with key [" + key + "].");
        return value;
    }

    protected String lookup(List<String> propertyChain, String value) {
        String result = value;
        Object[] ref = StringUtils.substringsBetween((String)value, (String)START_REF, (String)END_REF);
        if (!ArrayUtils.isEmpty((Object[])ref)) {
            for (int i = 0; i < ref.length; ++i) {
                String refValue = ConfigurationImpl.defaultIsNull(this.getPropertyRecursively((String)ref[i], null, propertyChain), "");
                String refTag = START_REF + (String)ref[i] + END_REF;
                result = result.replace(refTag, refValue);
            }
        } else if (StringUtils.startsWith((String)value, (String)UDDI_REF)) {
            String env = this.getPropertyFromConfig("environment", "prd");
            String base = StringUtils.substringBetween((String)value, (String)UDDI_REF, (String)END_REF);
            String uddiKey = env + "-" + base;
            LOG.debug("Looking key [" + uddiKey + "]");
            result = this.uddi.getProperty(uddiKey);
        }
        LOG.debug("Returning value [" + result + "]");
        return result;
    }

    private static String defaultIsNull(String input, String defaultValue) {
        return input == null ? defaultValue : input;
    }

    public static synchronized void reset() {
        instance = null;
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        if (instance == null) {
            throw new IllegalStateException("reload called while instance is not initialized");
        }
        ConfigurationImpl.loadConfigModules();
    }

    @Override
    public boolean containsKey(String key) {
        this.init();
        return this.properties.containsKey(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.init();
        if (!StringUtils.isEmpty((String)key)) {
            this.properties.remove(key);
            if (!StringUtils.isEmpty((String)value)) {
                this.properties.put(key, value);
            }
        }
    }

    private void init() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.load(ConfigFactory.getConfigLocation(), this.properties);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed", (Throwable)e);
            }
        }
        if (this.uddi == null) {
            this.uddi = new Properties();
            this.load("/uddi/uddi-default.properties", this.uddi);
            this.load(this.properties.getProperty("uddi.local.cache.dir", System.getProperty("java.io.tmpdir")) + File.separator + "uddi-local.properties", this.uddi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load(String file, Properties props) {
        InputStream is;
        block11: {
            is = null;
            try {
                block10: {
                    LOG.info("Trying to load properties: " + file);
                    try {
                        is = ConnectorIOUtils.getResourceAsStream(file);
                    }
                    catch (TechnicalConnectorException e) {
                        if (!"/be.ehealth.technicalconnector.properties".equals(file)) break block10;
                        String moddedFile = "./" + file;
                        LOG.info("Trying to load properties: " + file);
                        is = ConnectorIOUtils.getResourceAsStream(moddedFile);
                    }
                }
                if (is != null) {
                    props.load(is);
                    String remove = props.getProperty("remove.trail.withspaces", "true");
                    LOG.debug("Removing trailing withspaces? " + remove);
                    for (Object key : props.keySet()) {
                        String keyString = (String)key;
                        if (!"true".equals(remove) && !keyString.toLowerCase().startsWith("endpoint")) continue;
                        String value = props.getProperty(keyString);
                        props.setProperty(keyString, StringUtils.trim((String)value));
                    }
                    break block11;
                }
                LOG.error("Loading properties failed: " + file);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed: " + file, (Throwable)e);
                ConnectorIOUtils.closeQuietly((Object)is);
            }
            catch (IOException e2) {
                LOG.error("Loading properties failed: " + file, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        ConnectorIOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                ConnectorIOUtils.closeQuietly((Object)is);
            }
        }
        ConnectorIOUtils.closeQuietly((Object)is);
    }

    @Override
    public boolean hasProperty(String key) {
        this.init();
        return this.properties != null && this.properties.containsKey(key);
    }

    @Override
    public boolean hasMatchingProperty(String rootKey) {
        String key = rootKey + "." + 1;
        return this.hasProperty(key);
    }

    @Override
    public List<String> getMatchingProperties(String rootKey) {
        this.init();
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        String key;
        while (this.hasProperty(key = rootKey + "." + i)) {
            ret.add(this.getProperty(key));
            ++i;
        }
        return ret;
    }

    public String getPropertySubstitution(String key, String substitionKey, String value) {
        String propValue = this.getProperty(key);
        if (substitionKey != null && value != null) {
            return propValue.replace(substitionKey, value);
        }
        return propValue;
    }

    @Override
    @Deprecated
    public void setConfigLocation(String location) throws TechnicalConnectorException {
        ConfigFactory.setConfigLocation(location);
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        return ConfigurationImpl.getInstance();
    }

    public static synchronized Configuration getInstance() throws TechnicalConnectorException {
        if (instance != null && ConfigurationImpl.instance.usedLocation != null && !ConfigurationImpl.instance.usedLocation.equals(ConfigFactory.getConfigLocation())) {
            instance = null;
        }
        if (instance == null) {
            instance = new ConfigurationImpl();
            if ("true".equals(System.getProperty(SYSPROP_MODULE_LOADING, "true"))) {
                ConfigurationImpl.loadConfigModules();
            }
        }
        return instance;
    }

    private static void loadConfigModules() throws TechnicalConnectorException {
        if (instance == null) {
            throw new IllegalStateException("loadConfigModules called while instance is not initialized yet");
        }
        ConfigurationImpl.processModule(null, null, ConfigurationModuleClassloader.class);
        ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper(CONNECTOR_CONFIGMODULES, null);
        List<ConfigurationModule> modulesToLoad = helper.getImplementations(true, true);
        ConfigurationModule loggingModule = null;
        ConfigurationModule classloadingModule = null;
        ConfigurationModule versionModule = null;
        ConfigurationModule spModule = null;
        ConfigurationModule propModule = null;
        ConfigurationModule trustModule = null;
        for (ConfigurationModule module : modulesToLoad) {
            if (module instanceof ConfigurationModuleLogging) {
                loggingModule = module;
                continue;
            }
            if (module instanceof ConfigurationModuleClassloader) {
                classloadingModule = module;
                continue;
            }
            if (module instanceof ConfigurationModuleVersion) {
                versionModule = module;
                continue;
            }
            if (module instanceof ConfigurationModuleSecurityProvider) {
                spModule = module;
                continue;
            }
            if (module instanceof ConfigurationModuleProperties) {
                propModule = module;
                continue;
            }
            if (!(module instanceof ConfigurationModuleTrustStore)) continue;
            trustModule = module;
        }
        if (classloadingModule != null) {
            modulesToLoad.remove(classloadingModule);
        }
        ConfigurationImpl.processModule(modulesToLoad, loggingModule, ConfigurationModuleLogging.class);
        ConfigurationImpl.processModule(modulesToLoad, versionModule, ConfigurationModuleVersion.class);
        ConfigurationImpl.processModule(modulesToLoad, propModule, ConfigurationModuleProperties.class);
        for (ConfigurationModule module : modulesToLoad) {
            module.init(instance);
        }
        ConfigurationImpl.processModule(modulesToLoad, spModule, ConfigurationModuleSecurityProvider.class);
        ConfigurationImpl.processModule(modulesToLoad, trustModule, ConfigurationModuleTrustStore.class);
    }

    private static void processModule(List<ConfigurationModule> modulesToLoad, ConfigurationModule module, Class<? extends ConfigurationModule> moduleClass) throws TechnicalConnectorException {
        if (module != null) {
            modulesToLoad.remove(module);
        } else {
            try {
                module = moduleClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
            }
        }
        ConfigurationImpl.loadDefaultModule(module);
    }

    private static void loadDefaultModule(ConfigurationModule module) throws TechnicalConnectorException {
        if (Boolean.parseBoolean(System.getProperty("be.ehealth.technicalconnector.config.impl.Configuration.use." + module.getClass().getSimpleName(), "true"))) {
            module.init(instance);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void invalidate() {
        for (ConfigurationModule module : cachedModules) {
            try {
                module.unload();
            }
            catch (TechnicalConnectorException e) {
                LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
        cachedModules = new ArrayList<ConfigurationModule>();
    }
}

