/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.impl.handler.ErrorCollectorHandler;
import be.ehealth.technicalconnector.validator.impl.handler.ForkContentHandler;
import be.ehealth.technicalconnector.validator.impl.handler.XOPValidationHandler;
import com.gc.iotools.stream.is.InputStreamFromOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBSource;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class ValidatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorHelper.class);
    private static final SAXParserFactory SAF = SAXParserFactory.newInstance();
    private static final TransformerFactory TRF = TransformerFactory.newInstance();

    private ValidatorHelper() {
        throw new UnsupportedOperationException();
    }

    public static void validate(Source source, boolean xop, String ... schemaLocations) throws TechnicalConnectorException {
        try {
            XOPValidationHandler handler = new XOPValidationHandler(xop);
            ValidatorHandler validator = ValidatorHelper.createValidatorForSchemaFiles(schemaLocations);
            ErrorCollectorHandler collector = new ErrorCollectorHandler(handler);
            validator.setErrorHandler(collector);
            SAXParser parser = SAF.newSAXParser();
            parser.parse(ValidatorHelper.convert(source), (DefaultHandler)new ForkContentHandler(handler, validator));
            ValidatorHelper.handleValidationResult(collector);
        }
        catch (Exception e) {
            throw ValidatorHelper.handleException(e);
        }
    }

    public static void validate(Source source, String ... schemaLocations) throws TechnicalConnectorException {
        ValidatorHelper.validate(source, false, schemaLocations);
    }

    public static void validate(Object jaxbObj, String rootSchemaFileLocation) throws TechnicalConnectorException {
        ValidatorHelper.validate(jaxbObj, jaxbObj.getClass(), rootSchemaFileLocation);
    }

    public static void validate(Object jaxbObj, Class xmlClass, String rootSchemaFileLocation) throws TechnicalConnectorException {
        if (jaxbObj == null) {
            LOG.error("Message is null");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_XML_INVALID, "Message is null");
        }
        ConnectorXmlUtils.dump(jaxbObj);
        LOG.debug("Validating with schema [" + rootSchemaFileLocation + "]");
        try {
            JAXBContext jaxbContext = JaxbContextFactory.getJaxbContextForClass(xmlClass);
            JAXBSource payload = new JAXBSource(jaxbContext, jaxbObj);
            ValidatorHelper.validate((Source)payload, rootSchemaFileLocation);
        }
        catch (Exception e) {
            throw ValidatorHelper.handleException(e);
        }
        LOG.debug("Message is valid.");
    }

    private static TechnicalConnectorException handleException(Exception e) {
        if (e instanceof TechnicalConnectorException) {
            return (TechnicalConnectorException)e;
        }
        LOG.error("Unable to validate object.", (Throwable)e);
        return new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_XML_INVALID, (Throwable)e, e.getMessage());
    }

    protected static ValidatorHandler createValidatorForSchemaFiles(String ... schemaFiles) throws TechnicalConnectorException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Object[] sources = new Source[]{};
            for (int i = 0; i < schemaFiles.length; ++i) {
                String schemaFile = schemaFiles[i];
                InputStream in = SchemaValidatorHandler.class.getResourceAsStream(schemaFile);
                if (in != null) {
                    if (schemaFiles.length == 1) {
                        sources = (Source[])ArrayUtils.add((Object[])sources, (Object)new StreamSource(SchemaValidatorHandler.class.getResource(schemaFile).toExternalForm()));
                        continue;
                    }
                    StreamSource source = new StreamSource(in);
                    sources = (Source[])ArrayUtils.add((Object[])sources, (Object)source);
                    continue;
                }
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_XML_INVALID, "Unable to find schemaFile " + schemaFile);
            }
            return schemaFactory.newSchema((Source[])sources).newValidatorHandler();
        }
        catch (Exception e) {
            throw ValidatorHelper.handleException(e);
        }
    }

    private static void handleValidationResult(ErrorCollectorHandler collector) throws TechnicalConnectorException {
        if (collector.hasExceptions("WARN")) {
            List<String> validationWarning = collector.getExceptionList("WARN");
            for (String exception : validationWarning) {
                LOG.warn(exception);
            }
        }
        if (collector.hasExceptions("ERROR", "FATAL")) {
            StringBuilder sb = new StringBuilder();
            List<String> validationErrors = collector.getExceptionList("ERROR", "FATAL");
            for (String exception : validationErrors) {
                LOG.error(exception);
                sb.append(exception);
                sb.append(", ");
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_XML_INVALID, sb.toString());
        }
    }

    private static InputStream convert(final Source source) {
        try {
            InputStreamFromOutputStream<Void> isOs = new InputStreamFromOutputStream<Void>(){

                protected Void produce(OutputStream sink) throws Exception {
                    StreamResult result = new StreamResult(sink);
                    Transformer transformer = TRF.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(source, result);
                    return null;
                }
            };
            return isOs;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        SAF.setNamespaceAware(true);
    }
}

