/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public enum BeIDDigest {
    PLAIN_TEXT(null, new byte[]{48, -1, 48, 9, 6, 7, 96, 56, 1, 2, 1, 3, 1, 4, -1}),
    SHA_1("SHA-1", new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20}),
    SHA_224("SHA-224", new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28}),
    SHA_256("SHA-256", new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32}),
    SHA_384("SHA-384", new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48}),
    SHA_512("SHA-512", new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64}),
    RIPEMD_128("RIPEMD128", new byte[]{48, 29, 48, 9, 6, 5, 43, 36, 3, 2, 2, 5, 0, 4, 16}),
    RIPEMD_160("RIPEMD160", new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20}),
    RIPEMD_256("RIPEMD256", new byte[]{48, 45, 48, 9, 6, 5, 43, 36, 3, 2, 3, 5, 0, 4, 32}),
    SHA3_256("SHA3-256", new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 8, 5, 0, 4, 32}),
    SHA3_384("SHA3-384", new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 9, 5, 0, 4, 48}),
    SHA3_512("SHA3-512", new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 10, 5, 0, 4, 64}),
    SHA_1_PSS("SHA-1", new byte[0], 16),
    SHA_256_PSS("SHA-256", new byte[0], 32),
    ECDSA_SHA_2_256("SHA-256", new byte[0], 1, true),
    ECDSA_SHA_2_384("SHA-384", new byte[0], 2, true),
    ECDSA_SHA_2_512("SHA-512", new byte[0], 4, true),
    ECDSA_SHA_3_256("SHA3-256", new byte[0], 8, true),
    ECDSA_SHA_3_384("SHA3-384", new byte[0], 16, true),
    ECDSA_SHA_3_512("SHA3-512", new byte[0], 32, true),
    ECDSA_SHA_2_256_P1363("SHA-256", new byte[0], 1, true, true),
    ECDSA_SHA_2_384_P1363("SHA-384", new byte[0], 2, true, true),
    ECDSA_SHA_2_512_P1363("SHA-512", new byte[0], 4, true, true),
    ECDSA_SHA_3_256_P1363("SHA3-256", new byte[0], 8, true, true),
    ECDSA_SHA_3_384_P1363("SHA3-384", new byte[0], 16, true, true),
    ECDSA_SHA_3_512_P1363("SHA3-512", new byte[0], 32, true, true),
    NONE(null, new byte[0]),
    ECDSA_NONE(null, new byte[0], 64, true),
    ECDSA_NONE_P1363(null, new byte[0], 64, true, true);

    private final byte[] prefix;
    private final byte algorithmReference;
    private final boolean ec;
    private final boolean p1363;
    private final String algorithm;

    private BeIDDigest(String algorithm, byte[] prefix, int algorithmReference, boolean ec, boolean p1363) {
        this.algorithm = algorithm;
        this.prefix = prefix;
        this.algorithmReference = (byte)algorithmReference;
        this.ec = ec;
        this.p1363 = p1363;
    }

    private BeIDDigest(String algorithm, byte[] prefix, int algorithmReference, boolean ec) {
        this(algorithm, prefix, algorithmReference, ec, false);
    }

    private BeIDDigest(String algorithm, byte[] prefix, int algorithmReference) {
        this(algorithm, prefix, algorithmReference, false, false);
    }

    private BeIDDigest(String algorithm, byte[] prefix) {
        this(algorithm, prefix, 1);
    }

    public static BeIDDigest getInstance(String name) {
        return BeIDDigest.valueOf(name);
    }

    public byte[] getPrefix(int valueLength) {
        if (this.equals((Object)PLAIN_TEXT)) {
            byte[] digestInfoPrefix = Arrays.copyOf(this.prefix, this.prefix.length);
            digestInfoPrefix[1] = (byte)(valueLength + 13);
            digestInfoPrefix[14] = (byte)valueLength;
            return digestInfoPrefix;
        }
        return this.prefix;
    }

    public byte getAlgorithmReference() {
        return this.algorithmReference;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        if (null == this.algorithm) {
            return null;
        }
        return MessageDigest.getInstance(this.algorithm);
    }

    public boolean isEc() {
        return this.ec;
    }

    public boolean isP1363() {
        return this.p1363;
    }
}

