/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.domain;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.ra.domain.GeneratedRevocationContract;
import be.fgov.ehealth.technicalconnector.ra.domain.Request;
import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public final class RevocationRequest
extends Request
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyIdentifier;
    private GeneratedRevocationContract contract;
    private boolean contractViewed;

    public RevocationRequest(byte[] publicKeyIdentifier, GeneratedRevocationContract contract) throws TechnicalConnectorException {
        Validate.notNull((Object)publicKeyIdentifier);
        Validate.notNull((Object)contract);
        Validate.isTrue((boolean)contract.isContractViewed());
        this.publicKeyIdentifier = ArrayUtils.clone((byte[])publicKeyIdentifier);
        this.contract = contract;
    }

    public byte[] getPublicKeyIdentifier() {
        return this.publicKeyIdentifier;
    }

    public GeneratedRevocationContract getContract() {
        return this.contract;
    }

    public boolean isContractViewed() {
        return this.contractViewed;
    }

    public void setContractViewed(boolean contractViewed) {
        this.contractViewed = contractViewed;
    }
}

