/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import joptsimple.internal.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.VerificationSequenceDTO;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationSequenceValidator;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationSequenceSerializer
implements Serializer<VerificationSequence> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationSequenceValidator verificationSequenceValidator = new JsonSchemaVerificationSequenceValidator();

    @Override
    public String serialize(VerificationSequence verificationSequence) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationSequenceDTO(verificationSequence));
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing verificationSequence to JSON with value " + verificationSequence, (Throwable)e);
            throw new RuntimeException("Exception while serializing verificationSequence to JSON with value " + verificationSequence, e);
        }
    }

    @Override
    public VerificationSequence deserialize(String jsonVerificationSequence) {
        if (Strings.isNullOrEmpty((String)jsonVerificationSequence)) {
            throw new IllegalArgumentException("1 error:\n - a verification sequence is required but value was \"" + String.valueOf(jsonVerificationSequence) + "\"");
        }
        String validationErrors = this.verificationSequenceValidator.isValid(jsonVerificationSequence);
        if (validationErrors.isEmpty()) {
            VerificationSequence verificationSequence = null;
            try {
                VerificationSequenceDTO verificationDTO = (VerificationSequenceDTO)this.objectMapper.readValue(jsonVerificationSequence, VerificationSequenceDTO.class);
                if (verificationDTO != null) {
                    verificationSequence = verificationDTO.buildObject();
                }
            }
            catch (Exception ioe) {
                this.logger.info("Exception while parsing [" + jsonVerificationSequence + "] for VerificationSequence", (Throwable)ioe);
                throw new RuntimeException("Exception while parsing [" + jsonVerificationSequence + "] for VerificationSequence", ioe);
            }
            return verificationSequence;
        }
        this.logger.info("Validation failed:" + Character.NEW_LINE + validationErrors + Character.NEW_LINE + "-- Expectation:" + Character.NEW_LINE + jsonVerificationSequence + Character.NEW_LINE + "-- Schema:" + Character.NEW_LINE + this.verificationSequenceValidator.getSchema());
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<VerificationSequence> supportsType() {
        return VerificationSequence.class;
    }
}

