﻿using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.mycarenet.memberdatav2.builders;
using be.ehealth.businessconnector.mycarenet.memberdatav2.builders.impl;
using be.ehealth.businessconnector.mycarenet.memberdatav2.session.builders;
using be.ehealth.businessconnector.mycarenet.memberdatav2.session.builders.impl;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mycarenet.memberdata.protocol.v1;

using NUnit.Framework;

namespace be.ehealth.businessconnector.mycarenet.memberdatav2.session
{
	
	public abstract class AbstractIntegrationTest {
		
		public static BuilderStrategy ENCRYPTED_STRATEGY = new EncryptedBuilderStrategy();

    	public static BuilderStrategy UNENCRYPTED_STRATEGY = new UnencryptedBuilderStrategy();
		
		public AbstractIntegrationTest() {/* ... */}
		
		[SetUp]
		public abstract void init();
		
		[TearDown]
		public void tearDown() {
			SessionDestroyer.destroy();
		}
		
		public MemberDataConsultationRequest buildRequest(string inputRef, BuilderStrategy strategy, object content) {
	        be.ehealth.technicalconnector.utils.ConnectorXmlUtils.dump(content);
	
	        // input reference and AttributeQuery ID must match
	        InputReference inputReference = new InputReference(inputRef);
	
	        return strategy.build(true, inputReference, content);
	    }
		
	}
	
}
