/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.tsl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.fgov.ehealth.technicalconnector.bootstrap.tsl.parser.TrustServiceStatusListParser;
import be.fgov.ehealth.technicalconnector.bootstrap.tsl.signature.TrustServiceStatusListSignatureVerifier;
import be.fgov.ehealth.technicalconnector.bootstrap.utils.BootStrapUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrustStoreUpdater {
    private static final String PROP_CA_STOREPWD = "CAKEYSTORE_PASSWORD";
    private static final String PROP_CA_STORELOCATION = "CAKEYSTORE_LOCATION";
    private static final String CA_QC = "http://uri.etsi.org/TrstSvc/Svctype/CA/QC";
    private static final String CA_PKC = "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC";
    private static final String TSA = "http://uri.etsi.org/TrstSvc/Svctype/TSA";
    private static final String TSL = "http://uri.etsi.org/TrstSvd/Svctype/TLIssuer";
    private static final String NEXT_UPDATE_SUFFIX = "-nextUpdate";
    private static final Logger LOG = LoggerFactory.getLogger(TrustStoreUpdater.class);
    private static Properties shaCache = new Properties();
    private static String shaCacheLocation;

    private TrustStoreUpdater() {
        throw new UnsupportedOperationException();
    }

    public static void launch() throws TechnicalConnectorException {
        TrustStoreUpdater.init();
        BootStrapUtils.merge(TrustStoreUpdater.location("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location"), TrustStoreUpdater.pwd("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd"), TrustStoreUpdater.location(PROP_CA_STORELOCATION), TrustStoreUpdater.pwd(PROP_CA_STOREPWD));
        TrustStoreUpdater.update("ssl", TrustStoreUpdater.determineEndpoint(TrustedServiceType.TRANSPORT), TrustStoreUpdater.location("truststore_location"), TrustStoreUpdater.pwd("truststore_password"), CA_PKC, CA_QC);
        TrustStoreUpdater.store();
        TrustStoreUpdater.update("ca", TrustStoreUpdater.determineEndpoint(TrustedServiceType.PERSON), TrustStoreUpdater.location(PROP_CA_STORELOCATION), TrustStoreUpdater.pwd(PROP_CA_STOREPWD), CA_PKC, CA_QC);
        TrustStoreUpdater.store();
        TrustStoreUpdater.update("tsl", TrustStoreUpdater.determineEndpoint(TrustedServiceType.APPLICATION), TrustStoreUpdater.location("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location"), TrustStoreUpdater.pwd("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd"), CA_PKC, CA_QC, TSL);
        TrustStoreUpdater.store();
        TrustStoreUpdater.update("tsa", TrustStoreUpdater.determineEndpoint(TrustedServiceType.APPLICATION), TrustStoreUpdater.location("timestamp.signature.keystore.path"), TrustStoreUpdater.pwd("timestamp.signature.keystore.pwd"), CA_PKC, CA_QC, TSA);
        TrustStoreUpdater.store();
        BootStrapUtils.merge(TrustStoreUpdater.location("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location"), TrustStoreUpdater.pwd("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd"), TrustStoreUpdater.location(PROP_CA_STORELOCATION), TrustStoreUpdater.pwd(PROP_CA_STOREPWD));
        ConfigValidator config = ConfigFactory.getConfigValidator();
        config.invalidate();
        config.reload();
    }

    private static String determineEndpoint(TrustedServiceType type) {
        String env = ConfigFactory.getConfigValidator().getProperty("environment", "prd");
        String endpoint = ConfigFactory.getConfigValidator().getProperty(type.getKey());
        if (StringUtils.isNotBlank((CharSequence)endpoint)) {
            return endpoint;
        }
        if ("prd".equals(env)) {
            return "https://tsl.ehealth.fgov.be/" + type.getPath();
        }
        if ("acc".equals(env)) {
            return "https://tsl-acpt.ehealth.fgov.be/" + type.getPath();
        }
        if ("int".equals(env)) {
            return "https://tsl-int.ehealth.fgov.be/" + type.getPath();
        }
        throw new IllegalArgumentException("Unsupported Environment [" + env + "]");
    }

    private static void init() {
        InputStream is = null;
        try {
            shaCacheLocation = ConfigFactory.getConfigValidator().getProperty("truststoreupdater.local.cache", ConnectorIOUtils.getTempFileLocation((String)(TrustStoreUpdater.class.getCanonicalName() + ".properties")));
            is = ConnectorIOUtils.getResourceAsStream((String)shaCacheLocation);
            shaCache.load(is);
            ConnectorIOUtils.closeQuietly((Object)is);
        }
        catch (Exception e) {
            LOG.error("Unable to load sha cache", (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly(is);
        }
    }

    private static void store() {
        if (StringUtils.isNotEmpty((CharSequence)shaCacheLocation)) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(shaCacheLocation));
                shaCache.store(fos, "eHealth TSL cache");
            }
            catch (Exception e) {
                try {
                    LOG.error("Unable to store fingerprints to cache", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(fos);
                    throw throwable;
                }
                ConnectorIOUtils.closeQuietly((Object)fos);
            }
            ConnectorIOUtils.closeQuietly((Object)fos);
        }
    }

    private static String location(String key) throws TechnicalConnectorException {
        String location = ConfigFactory.getConfigValidator().getProperty(key);
        try {
            ConnectorIOUtils.getResourceAsStream((String)location);
            return location;
        }
        catch (TechnicalConnectorException e) {
            location = ConfigFactory.getConfigValidator().getProperty("KEYSTORE_DIR") + ConfigFactory.getConfigValidator().getProperty(key);
            LOG.debug("Trying to obtain location by adding ${KEYSTORE_DIR} [" + location + "] Reason " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            ConnectorIOUtils.getResourceAsStream((String)location);
            return location;
        }
    }

    private static char[] pwd(String key) {
        return ConfigFactory.getConfigValidator().getProperty(key).toCharArray();
    }

    private static void update(String type, String tslEndpoint, String storeLocation, char[] storepwd, String ... serviceTypeIdentifiers) throws TechnicalConnectorException {
        String cacheSha;
        String sha = ConnectorIOUtils.convertStreamToString((InputStream)ConnectorIOUtils.getResourceAsStream((String)(tslEndpoint + ".sha2")));
        if (shaCache.containsKey(type) && (cacheSha = shaCache.getProperty(type)).equals(sha) && DateUtils.parseDateTime((String)shaCache.getProperty(type + NEXT_UPDATE_SUFFIX)).isAfterNow()) {
            LOG.info("Truststore already up-to-date. Skipping TSL file [" + tslEndpoint + "]");
            return;
        }
        String xml = ConnectorIOUtils.convertStreamToString((InputStream)ConnectorIOUtils.getResourceAsStream((String)(tslEndpoint + ".xml")));
        if (TrustServiceStatusListSignatureVerifier.isValid(xml)) {
            TrustServiceStatusListParser parser = new TrustServiceStatusListParser();
            parser.parse(xml, serviceTypeIdentifiers);
            BootStrapUtils.writeKeyStore(parser.getTrustedList(), storeLocation, storepwd);
            if (!StringUtils.isEmpty((CharSequence)sha)) {
                shaCache.put(type, sha);
                shaCache.put(type + NEXT_UPDATE_SUFFIX, DateUtils.printDateTime((DateTime)parser.nextUpdate()));
            }
        } else {
            LOG.warn("Invalid TSL file on [" + tslEndpoint + "], skipping update");
        }
    }

    private static enum TrustedServiceType {
        APPLICATION("tsl-ehpbe-application", "endpoint.tsl.appl"),
        PERSON("tsl-ehpbe-person", "endpoint.tsl.person"),
        TRANSPORT("tsl-ehpbe-transport", "endpoint.tsl.transport");

        private String path;
        private String propKey;

        private TrustedServiceType(String path, String propKey) {
            this.path = path;
            this.propKey = propKey;
        }

        public String getPath() {
            return this.path;
        }

        public String getKey() {
            return this.propKey;
        }
    }
}

