/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer.tlv;

import be.fedict.commons.eid.consumer.tlv.DataConvertor;
import be.fedict.commons.eid.consumer.tlv.DataConvertorException;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateOfBirthDataConvertor
implements DataConvertor<GregorianCalendar> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateOfBirthDataConvertor.class);
    private static final String[][] MONTHS = new String[][]{{"JAN"}, {"FEV", "FEB"}, {"MARS", "MAAR", "M\u00c4R"}, {"AVR", "APR"}, {"MAI", "MEI"}, {"JUIN", "JUN"}, {"JUIL", "JUL"}, {"AOUT", "AUG"}, {"SEPT", "SEP"}, {"OCT", "OKT"}, {"NOV"}, {"DEC", "DEZ"}};

    @Override
    public GregorianCalendar convert(byte[] value) throws DataConvertorException {
        String dateOfBirthStr;
        try {
            dateOfBirthStr = new String(value, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException uex) {
            throw new DataConvertorException("UTF-8 not supported");
        }
        LOGGER.debug("\"{}\"", (Object)dateOfBirthStr);
        int spaceIdx = dateOfBirthStr.indexOf(46);
        if (-1 == spaceIdx) {
            spaceIdx = dateOfBirthStr.indexOf(32);
        }
        if (spaceIdx > 0) {
            String dayStr = dateOfBirthStr.substring(0, spaceIdx);
            LOGGER.debug("day: \"{}\"", (Object)dayStr);
            int day = Integer.parseInt(dayStr);
            String monthStr = dateOfBirthStr.substring(spaceIdx + 1, dateOfBirthStr.length() - 4 - 1);
            if (monthStr.endsWith(".")) {
                monthStr = monthStr.substring(0, monthStr.length() - 1);
            }
            LOGGER.debug("month: \"{}\"", (Object)monthStr);
            String yearStr = dateOfBirthStr.substring(dateOfBirthStr.length() - 4);
            LOGGER.debug("year: \"{}\"", (Object)yearStr);
            int year = Integer.parseInt(yearStr);
            int month = this.toMonth(monthStr);
            return new GregorianCalendar(year, month, day);
        }
        if (dateOfBirthStr.length() == 4) {
            return new GregorianCalendar(Integer.parseInt(dateOfBirthStr), 0, 1);
        }
        throw new DataConvertorException("Unsupported Birth Date Format [" + dateOfBirthStr + "]");
    }

    private int toMonth(String monthStr) throws DataConvertorException {
        monthStr = monthStr.trim();
        for (int monthIdx = 0; monthIdx < MONTHS.length; ++monthIdx) {
            String[] monthNames;
            for (String monthName : monthNames = MONTHS[monthIdx]) {
                if (!monthName.equals(monthStr)) continue;
                return monthIdx;
            }
        }
        throw new DataConvertorException("unknown month: " + monthStr);
    }
}

