/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer;

import be.fedict.commons.eid.consumer.Address;
import be.fedict.commons.eid.consumer.Identity;
import be.fedict.commons.eid.consumer.tlv.TlvParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDIntegrity {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDIntegrity.class);
    private final CertificateFactory certificateFactory;
    private final KeyFactory keyFactory;

    public BeIDIntegrity() {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
            this.keyFactory = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException | CertificateException cex) {
            throw new RuntimeException("algo", cex);
        }
    }

    public X509Certificate loadCertificate(byte[] encodedCertificate) {
        X509Certificate certificate;
        try {
            certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(encodedCertificate));
        }
        catch (CertificateException cex) {
            throw new RuntimeException("X509 decoding error: " + cex.getMessage(), cex);
        }
        return certificate;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, X509Certificate rrnCertificate) {
        Identity identity = this.getVerifiedIdentity(identityFile, identitySignatureFile, null, rrnCertificate);
        return identity;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, byte[] photo, X509Certificate rrnCertificate) {
        byte[] actualPhotoDigest;
        byte[] expectedPhotoDigest;
        boolean result;
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            result = this.verifySignature(rrnCertificate.getSigAlgName(), identitySignatureFile, publicKey, (byte[][])new byte[][]{identityFile});
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new SecurityException("identity signature verification error: " + ex.getMessage(), ex);
        }
        if (!result) {
            throw new SecurityException("signature integrity error");
        }
        Identity identity = TlvParser.parse(identityFile, Identity.class);
        if (null != photo && !Arrays.equals(expectedPhotoDigest = identity.getPhotoDigest(), actualPhotoDigest = this.digest(this.getDigestAlgo(expectedPhotoDigest.length), photo))) {
            throw new SecurityException("photo digest mismatch");
        }
        return identity;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, byte[] photo, byte[] challenge, byte[] cardSignatureValue, byte[] basicPublicKeyFile, X509Certificate rrnCertificate) {
        boolean result;
        Identity identity = this.getVerifiedIdentity(identityFile, identitySignatureFile, photo, rrnCertificate);
        try {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(basicPublicKeyFile);
            PublicKey basicPublicKey = this.keyFactory.generatePublic(publicKeySpec);
            Signature signature = Signature.getInstance("SHA384withECDSA");
            signature.initVerify(basicPublicKey);
            signature.update(challenge);
            result = signature.verify(cardSignatureValue);
        }
        catch (Exception e) {
            throw new SecurityException("card basic signature incorrect");
        }
        if (!result) {
            throw new SecurityException("card basic signature incorrect");
        }
        byte[] expectedBasicPublicKeyDigest = identity.getBasicPublicKeyDigest();
        if (null == expectedBasicPublicKeyDigest) {
            throw new SecurityException("missing basic public key digest");
        }
        byte[] actualBasicPublicKeyDigest = this.digest(this.getDigestAlgo(expectedBasicPublicKeyDigest.length), basicPublicKeyFile);
        if (!Arrays.equals(expectedBasicPublicKeyDigest, actualBasicPublicKeyDigest)) {
            throw new SecurityException("basic public key digest mismatch");
        }
        return identity;
    }

    public Address getVerifiedAddress(byte[] addressFile, byte[] identitySignatureFile, byte[] addressSignatureFile, X509Certificate rrnCertificate) {
        boolean result;
        byte[] trimmedAddressFile = this.trimRight(addressFile);
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            result = this.verifySignature(rrnCertificate.getSigAlgName(), addressSignatureFile, publicKey, (byte[][])new byte[][]{trimmedAddressFile, identitySignatureFile});
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new SecurityException("address signature verification error: " + ex.getMessage(), ex);
        }
        if (!result) {
            throw new SecurityException("address integrity error");
        }
        Address address = TlvParser.parse(addressFile, Address.class);
        return address;
    }

    public boolean verifySignature(byte[] signatureData, PublicKey publicKey, byte[] ... data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        LOGGER.debug("public key algorithm: {}", (Object)publicKey.getAlgorithm());
        String signatureAlgo = "EC".equals(publicKey.getAlgorithm()) ? "SHA256withECDSA" : "SHA1withRSA";
        return this.verifySignature(signatureAlgo, signatureData, publicKey, data);
    }

    public boolean verifySignature(String signatureAlgo, byte[] signatureData, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signatureAlgo);
        signature.initVerify(publicKey);
        for (byte[] dataItem : data) {
            signature.update(dataItem);
        }
        if (null == signatureData) {
            throw new SignatureException("missing signature data");
        }
        if (signatureAlgo.contains("ECDSA")) {
            signatureData = this.fixECDSASignature(signatureData);
        }
        boolean result = signature.verify(signatureData);
        return result;
    }

    private byte[] fixECDSASignature(byte[] signature) {
        byte derSize = signature[1];
        if (signature.length > derSize + 2) {
            LOGGER.debug("signature too long: {} bytes", (Object)(signature.length - derSize - 2));
            byte[] fixedSignature = new byte[derSize + 2];
            System.arraycopy(signature, 0, fixedSignature, 0, derSize + 2);
            return fixedSignature;
        }
        return signature;
    }

    private byte[] digest(String algoName, byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algoName);
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RuntimeException(algoName);
        }
        byte[] digestValue = messageDigest.digest(data);
        return digestValue;
    }

    private byte[] trimRight(byte[] addressFile) {
        int idx;
        for (idx = 0; idx < addressFile.length && 0 != addressFile[idx]; ++idx) {
        }
        byte[] result = new byte[idx];
        System.arraycopy(addressFile, 0, result, 0, idx);
        return result;
    }

    public boolean verifyAuthnSignature(byte[] toBeSigned, byte[] signatureValue, X509Certificate authnCertificate) {
        boolean result;
        PublicKey publicKey = authnCertificate.getPublicKey();
        try {
            result = this.verifySignature(signatureValue, publicKey, new byte[][]{toBeSigned});
        }
        catch (InvalidKeyException ikex) {
            LOGGER.warn("invalid key: " + ikex.getMessage(), (Throwable)ikex);
            return false;
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOGGER.warn("no such algo: " + nsaex.getMessage(), (Throwable)nsaex);
            return false;
        }
        catch (SignatureException sigex) {
            LOGGER.warn("signature error: " + sigex.getMessage(), (Throwable)sigex);
            return false;
        }
        return result;
    }

    public boolean verifyNonRepSignature(byte[] expectedDigestValue, byte[] signatureValue, X509Certificate certificate) {
        PublicKey publicKey = certificate.getPublicKey();
        return this.verifyNonRepSignature(expectedDigestValue, signatureValue, publicKey);
    }

    public boolean verifyNonRepSignature(byte[] expectedDigestValue, byte[] signatureValue, PublicKey publicKey) {
        try {
            return this.__verifyNonRepSignature(expectedDigestValue, signatureValue, publicKey);
        }
        catch (InvalidKeyException ikex) {
            LOGGER.warn("invalid key: " + ikex.getMessage(), (Throwable)ikex);
            return false;
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOGGER.warn("no such algo: " + nsaex.getMessage(), (Throwable)nsaex);
            return false;
        }
        catch (NoSuchPaddingException nspex) {
            LOGGER.warn("no such padding: " + nspex.getMessage(), (Throwable)nspex);
            return false;
        }
        catch (BadPaddingException bpex) {
            LOGGER.warn("bad padding: " + bpex.getMessage(), (Throwable)bpex);
            return false;
        }
        catch (IOException ioex) {
            LOGGER.warn("IO error: " + ioex.getMessage(), (Throwable)ioex);
            return false;
        }
        catch (IllegalBlockSizeException ibex) {
            LOGGER.warn("illegal block size: " + ibex.getMessage(), (Throwable)ibex);
            return false;
        }
        catch (NoSuchProviderException e) {
            LOGGER.warn("no such provider: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SignatureException e) {
            LOGGER.warn("signature error: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean __verifyNonRepSignature(byte[] expectedDigestValue, byte[] signatureValue, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException, NoSuchProviderException, SignatureException {
        switch (publicKey.getAlgorithm()) {
            case "RSA": {
                return this.__verifyNonRepSignatureRSA(expectedDigestValue, signatureValue, publicKey);
            }
            case "EC": {
                return this.__verifyNonRepSignatureEC(expectedDigestValue, signatureValue, publicKey);
            }
        }
        throw new IllegalArgumentException("unsupported key algo: " + publicKey.getAlgorithm());
    }

    private boolean __verifyNonRepSignatureRSA(byte[] expectedDigestValue, byte[] signatureValue, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        DigestInfo actualSignatureDigestInfo;
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        byte[] actualSignatureDigestInfoValue = cipher.doFinal(signatureValue);
        try (ASN1InputStream asnInputStream = new ASN1InputStream(actualSignatureDigestInfoValue);){
            actualSignatureDigestInfo = new DigestInfo((ASN1Sequence)asnInputStream.readObject());
        }
        byte[] actualDigestValue = actualSignatureDigestInfo.getDigest();
        return Arrays.equals(expectedDigestValue, actualDigestValue);
    }

    private boolean __verifyNonRepSignatureEC(byte[] expectedDigestValue, byte[] signatureValue, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException {
        Signature signature = Signature.getInstance("NONEwithECDSA", "BC");
        signature.initVerify(publicKey);
        signature.update(expectedDigestValue);
        return signature.verify(signatureValue);
    }

    private String getDigestAlgo(int hashSize) throws SecurityException {
        switch (hashSize) {
            case 20: {
                return "SHA-1";
            }
            case 28: {
                return "SHA-224";
            }
            case 32: {
                return "SHA-256";
            }
            case 48: {
                return "SHA-384";
            }
            case 64: {
                return "SHA-512";
            }
        }
        throw new SecurityException("Failed to find guess algorithm for hash size of " + hashSize + " bytes");
    }
}

