/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.therlink.domain;

import be.ehealth.businessconnector.therlink.domain.Author;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.OperationContext;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Unit test class for {@link OperationContext}
 * 
 * @author Priscilla Colleaux
 * 
 */
public class OperationContextTest {

    @Test
    public void testEquals() throws Exception {
        HcParty hcp = new HcParty.Builder().withApplicationID("456123").withName("ignored").withType("application").build();

        Author author = new Author.Builder().addHcParty(hcp).build();
        String declaration = "declaration";
        DateTime timeToUse = new DateTime();
        OperationContext oc1 = new OperationContext(timeToUse, declaration, author, null);
        OperationContext oc2 = new OperationContext(timeToUse, declaration, author, null);

        Assert.assertTrue("Operation contexts are not equal", oc1.equals(oc2));
    }


}
