﻿﻿/*
 * Copyright (c) eHealth
 */
using System;

using java.util;
using NUnit.Framework;

using be.ehealth.technicalconnector.config;
using be.fgov.ehealth.technicalconnector.services;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;


using be.fgov.ehealth.technicalconnector.session;

using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils.net;

namespace be.fgov.ehealth.technicalconnector.services
{
	/// <summary>
	/// Description of DataAttributeServiceIntegrationTest.
	/// </summary>
	public class DataAttributeServiceIntegrationTest
	{
		private static Properties props;
		
		[SetUpAttribute]
		public static void setupsession() {
			SessionInitializer.init(".\\be.ehealth.technicalconnector.daas.test.properties",true, SupportedLanguages.NET.getAbbreviation());
			props = TestPropertiesNetLoader.getProperties(".\\be.ehealth.technicalconnector.daas.test.properties",".net");
			ConfigFactory.getConfigValidator().setProperty("endpoint.daas.v1", "https://services-acpt.ehealth.fgov.be/DAtaAttributeService/v1");
			
		}
		
		[Test]
		public void invokeSuccess() {

			Map attr = new HashMap();
			String ssin = props.getProperty("test.daas.success.ssin");
			attr.put("urn:be:fgov:person:ssin", Arrays.asList(ssin));
			attr.put("urn:be:fgov:person:ssin:ehealth:1.0:listofpreventionservices", null);
			attr.put("urn:be:fgov:ehealth:1.0:service-name", Arrays.asList(props.getProperty("test.daas.success.service-name")));

			Map result = ServiceFactory.getDataAttributeService().invoke(attr);

			Assert.AreEqual(3, result.size());
			
		}
	}
}
