﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.util.regex;
using org.joda.time;
using be.cin.nip.async.generic;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.utils;

namespace be.ehealth.businessconnector.genericasync.test.util
{
	/**
	 * some utility methods for gen async tests.
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class TestUtil
	{
		public static void addTackToSb(java.lang.StringBuilder sb, TAck tAck) {
	        sb.append("\n").append(tAck.getAppliesTo()).append("   ").append(tAck.getId()).append("   ").append(tAck.getIssuer()).append("   ").append(tAck.getResultMajor()).append("   ").append(tAck.getResultMinor()).append("   ").append(tAck.getResultMessage());
	    }
	
	
	    /**
	     * hide constructor.
	     */
	    private TestUtil() {
	    }
	
	
	    /**
	     * @param xmlTemplate
	     * @return
	     */
	    public static String fillOutPlaceHolders(String xmlTemplate) {
	        String output = xmlTemplate;
	        output = replaceString(output, "$$doctor.nihi.number$$", SessionUtil.getNihii11());
	        output = replaceString(output, "$$doctor.inss.number$$", SessionUtil.getNiss());
	        output = replaceString(output, "$$doctor.firstname$$", SessionUtil.getFirstname());
	        output = replaceString(output, "$$doctor.lastname$$", SessionUtil.getLastname());
	        org.joda.time.DateTime dateTime = new org.joda.time.DateTime();
	
	        output = replaceString(output, "$$date.today$$", DateUtils.printDate(dateTime));
	        output = replaceString(output, "$$time.today$$", DateUtils.printTime(dateTime));
	        output = replaceString(output, "$$generated.id$$", IdGeneratorFactory.getIdGenerator().generateId());
	        return output;
	    }
	
	
	    /**
	     * @param input
	     * @param stringToReplace
	     * @param replacementString
	     * @return
	     */
	    public static String replaceString(String input,  String stringToReplace,  String replacementString) {
	        return input.replaceAll(Matcher.quoteReplacement(stringToReplace), replacementString);
	    }
	}
}
