package be.fgov.ehealth.technicalconnector.tests.server.asserter;

import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.apache.commons.io.IOUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.*;

public class XmlUnitAsserter implements HttpAsserter {

    private String input;
    private String output;

    public XmlUnitAsserter(String input, String output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public HttpResponse assertSession(HttpRequest session) throws Exception {
        XmlAsserter.assertSimilar(getResourceAsString(input), session.getBodyAsString());
        byte[] body = getResourceAsByteArray(output);
        return HttpResponse.response()
                .withStatusCode(200)
                .withHeader("Content-Type","text/xml")
                .withBody(body);
    }
}
