/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.etee.impl;

import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;
import org.junit.*;

import java.security.KeyStore;


/**
 * Class to test the behaviour of {@link ConnectorRevocationStatusChecker}
 *
 * @author EHP
 */
public class ConnectorRevocationStatusCheckerUserIntegrationTest {

    private static final String INSTANCE_NAME = "test";

    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();


    @Before
    public void before() throws Exception {
        AssumeTools.isEIDEnabled();
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        BeIDCredential beID = BeIDCredential.getInstance(INSTANCE_NAME, BeIDCredential.EID_AUTH_ALIAS);
        store.setCertificateEntry("ca", beID.getCertificateChain()[1]);
        store.setCertificateEntry("ca2", beID.getCertificateChain()[2]);
    }


    @After
    public void after() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.deleteEntry("ca");
        store.deleteEntry("ca2");
    }

    @Test
    public void testWithEid() throws Exception {
        ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
        BeIDCredential beID = BeIDCredential.getInstance(INSTANCE_NAME, BeIDCredential.EID_AUTH_ALIAS);
        boolean isRevoked = checker.isRevoked(beID.getCertificate());
        Assert.assertFalse(isRevoked);
    }

}
