/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public enum KeyType {
    RSA,
    DSA,
    EC;


    public static KeyType from(SigningCredential signingCredential) {
        if (signingCredential.getPublicKey() != null) {
            return KeyType.from(signingCredential.getPublicKey());
        }
        if (!signingCredential.getCertificateChain().isEmpty()) {
            return KeyType.from(signingCredential.getCertificateChain().get(0).getPublicKey());
        }
        if (signingCredential.getPrivateKey() != null) {
            return KeyType.from(signingCredential.getPrivateKey());
        }
        throw new IllegalArgumentException("KeyType could not be determined from credential: " + signingCredential);
    }

    public static KeyType from(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            return RSA;
        }
        if (publicKey instanceof DSAPublicKey) {
            return DSA;
        }
        if (publicKey instanceof ECPublicKey) {
            return EC;
        }
        throw new IllegalArgumentException("KeyType not supported: " + publicKey.getClass());
    }

    public static KeyType from(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            return RSA;
        }
        if (privateKey instanceof DSAPrivateKey) {
            return DSA;
        }
        if (privateKey instanceof ECPrivateKey) {
            return EC;
        }
        throw new IllegalArgumentException("KeyType not supported: " + privateKey.getClass());
    }
}

