/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.utils.CertStringBuilder;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptionTokenFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionTokenFactory.class);
    private static EncryptionTokenFactory instance;

    private EncryptionTokenFactory() {
        SecurityConfiguration.configure();
    }

    public static synchronized EncryptionTokenFactory getInstance() {
        if (instance == null) {
            instance = new EncryptionTokenFactory();
        }
        return instance;
    }

    public EncryptionToken create(File encryptionTokenFile) throws FileNotFoundException, GeneralSecurityException {
        return this.create(new FileInputStream(encryptionTokenFile));
    }

    public EncryptionToken create(InputStream encryptionTokenStream) throws GeneralSecurityException {
        return this.create(Streams.getBytes(encryptionTokenStream));
    }

    public EncryptionToken create(String encryptionTokenBase64) throws GeneralSecurityException {
        return this.create(Base64.decode((String)encryptionTokenBase64));
    }

    public EncryptionToken create(byte[] encryptionTokenKeyBytes) throws GeneralSecurityException {
        Preconditions.checkNotNull(encryptionTokenKeyBytes, "data cannot be null");
        byte[] encoded = (byte[])encryptionTokenKeyBytes.clone();
        ArrayList<X509Certificate> caCertChain = new ArrayList<X509Certificate>();
        try {
            CMSSignedDataParser signedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), encoded);
            X509Certificate encrCert = this.readEncryptionCert(signedDataParser);
            Store certStore = signedDataParser.getCertificates();
            X509Certificate etkRaCert = this.readETKRaCert(signedDataParser, (Store<X509CertificateHolder>)certStore);
            X509Certificate authCert = this.readCertStore(caCertChain, etkRaCert, (Store<X509CertificateHolder>)certStore);
            return new EncryptionToken(encoded, encrCert, authCert, caCertChain, etkRaCert);
        }
        catch (CMSException e) {
            throw new GeneralSecurityException("The ETK is not an encoded CMS data structure", e);
        }
    }

    private X509Certificate readCertStore(List<X509Certificate> caCertChain, X509Certificate etkRaCert, Store<X509CertificateHolder> certStore) {
        List<X509Certificate> cmsCertificates = this.toList(certStore.getMatches(null));
        X509Certificate authCert = null;
        for (X509Certificate cert : cmsCertificates) {
            if (cert.getBasicConstraints() >= 0) {
                caCertChain.add(cert);
                continue;
            }
            if (cert.equals(etkRaCert)) continue;
            authCert = cert;
            LOGGER.debug("CMS contains ETK AuthenticationCert");
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("ETK AuthenticationCert: " + CertStringBuilder.build(authCert));
        }
        LOGGER.debug("CMS contains #" + caCertChain.size() + " certificates in CA CertChain");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CA CertChain: " + CertStringBuilder.build(caCertChain));
        }
        return authCert;
    }

    private X509Certificate readETKRaCert(CMSSignedDataParser signedDataParser, Store<X509CertificateHolder> certStore) throws CMSException {
        SignerInformation etkSigner = (SignerInformation)signedDataParser.getSignerInfos().getSigners().iterator().next();
        SignerId etkSignerId = etkSigner.getSID();
        Collection etkSignerCerts = certStore.getMatches((Selector)etkSignerId);
        X509Certificate etkRaCert = this.extractCert((X509CertificateHolder)etkSignerCerts.iterator().next());
        LOGGER.debug("CMS contains ETK-RA Cert");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ETK-RA Cert: " + CertStringBuilder.build(etkRaCert));
        }
        return etkRaCert;
    }

    private X509Certificate readEncryptionCert(CMSSignedDataParser signedDataParser) throws CertificateException {
        X509Certificate encrCert = null;
        CMSTypedStream cmsStream = signedDataParser.getSignedContent();
        if (cmsStream != null) {
            InputStream is = cmsStream.getContentStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            encrCert = (X509Certificate)cf.generateCertificate(is);
            LOGGER.debug("CMS contains ETK EncryptionCert");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ETK EncryptionCert: " + CertStringBuilder.build(encrCert));
            }
        }
        return encrCert;
    }

    private X509Certificate extractCert(X509CertificateHolder certificateHolder) {
        try {
            return new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("The certificate could not be extracted", e);
        }
    }

    private List<X509Certificate> toList(Collection<X509CertificateHolder> collectionCertChain) {
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        for (X509CertificateHolder x509CertificateHolder : collectionCertChain) {
            certChain.add(this.extractCert(x509CertificateHolder));
        }
        return certChain;
    }
}

