/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerFactory {
    private static final String TRUSTSTORE_PASSWORD = "connector.configurationmodule.ssl.trustore.password";
    private static final String TRUSTSTORE_LOCATION = "connector.configurationmodule.ssl.trustore.location";
    private static final Logger LOG = LoggerFactory.getLogger(TrustManagerFactory.class);
    private static final String DEFAULT_ALGORITHM = "PKIX";

    public static TrustManager passThroughTrustManager() {
        return new PassThroughTrustManager();
    }

    public static TrustManager keystoreTrustManager(Configuration config) {
        try {
            String trustStoreLocation = config.getProperty(TRUSTSTORE_LOCATION, "${KEYSTORE_DIR}${truststore_location}");
            String pwdString = config.getProperty(TRUSTSTORE_PASSWORD, "${truststore_password}");
            char[] passwordCharArray = null;
            if (pwdString != null) {
                passwordCharArray = pwdString.toCharArray();
            }
            KeyStore trustStore = TrustManagerFactory.getStore(trustStoreLocation, passwordCharArray);
            TrustManagerFactory.dumpContext(trustStore, trustStoreLocation);
            javax.net.ssl.TrustManagerFactory factory = javax.net.ssl.TrustManagerFactory.getInstance(DEFAULT_ALGORITHM);
            factory.init(trustStore);
            return factory.getTrustManagers()[0];
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static KeyStore getStore(String storeLocation, char[] passwordCharArray) {
        KeyStore keyStore;
        InputStream is = null;
        try {
            KeyStore truststore = KeyStore.getInstance("JKS");
            is = ConnectorIOUtils.getResourceAsStream(storeLocation);
            truststore.load(is, passwordCharArray);
            keyStore = truststore;
        }
        catch (Exception e) {
            try {
                throw new ConfigurationException(e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)is);
        return keyStore;
    }

    private static void dumpContext(KeyStore store, String location) {
        try {
            LOG.debug("Content of KeyStore [{}]", (Object)location);
            ArrayList<String> aliases = Collections.list(store.aliases());
            Collections.sort(aliases);
            for (String alias : aliases) {
                Certificate cert = store.getCertificate(alias);
                X509Certificate x509Cert = (X509Certificate)cert;
                String dn = x509Cert.getSubjectX500Principal().getName("RFC2253");
                LOG.debug("\t.{}: {}", (Object)alias, (Object)dn);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static class PassThroughTrustManager
    implements X509TrustManager {
        private static final Logger LOG = LoggerFactory.getLogger(PassThroughTrustManager.class);

        private PassThroughTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            LOG.warn("SSL verifcation disabled! DO NOT USE THIS IN PRODUCTION.");
            LOG.debug("getAcceptedIssuers() : empty list");
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkClientTrusted() : authType={}", (Object)authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkServerTrusted() : authType={}", (Object)authType);
            for (int i = 0; i < certs.length; ++i) {
                LOG.debug("Server Certificate to be checked {} : {} with issuer: {}", new Object[]{i, certs[i].getSubjectX500Principal().getName("RFC1779"), certs[i].getIssuerX500Principal().getName("RFC1779")});
            }
        }
    }
}

