/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.cache.impl;

import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.CacheFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.shutdown.ShutdownHook;
import be.ehealth.technicalconnector.shutdown.ShutdownRegistry;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import org.joda.time.Duration;

public class JSR107Cache<K, V>
implements Cache<K, V>,
ConfigurableImplementation,
ShutdownHook {
    private javax.cache.Cache<K, V> cache;
    private CacheManager cacheManager = CacheImpl.INSTANCE.getCacheManager();

    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        try {
            String serviceName = (String)parameterMap.get("cacheName");
            CacheFactory.ExpiryType expiryType = (CacheFactory.ExpiryType)((Object)parameterMap.get("cacheExpiryType"));
            Duration expiryDuration = (Duration)parameterMap.get("cacheExpiryDuration");
            String cacheName = serviceName.replaceAll(":", "_");
            this.cache = this.cacheManager.getCache(cacheName, String.class, String.class);
            if (this.cache == null) {
                MutableConfiguration configuration = new MutableConfiguration().setStoreByValue(true).setStatisticsEnabled(true).setTypes(String.class, String.class);
                switch (expiryType) {
                    case NONE: {
                        configuration.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)javax.cache.expiry.Duration.ETERNAL));
                        break;
                    }
                    case TTL: {
                        configuration.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)new javax.cache.expiry.Duration(TimeUnit.MILLISECONDS, expiryDuration.getMillis())));
                        break;
                    }
                }
                this.cache = this.cacheManager.createCache(cacheName, (Configuration)configuration);
            }
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, (Throwable)e, "unable to instantiate JSR107 cache");
        }
        ShutdownRegistry.register(this);
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.cache.putAll(map);
    }

    @Override
    public void shutdown() {
        this.cacheManager.close();
    }

    private static enum CacheImpl {
        INSTANCE;


        public CacheManager getCacheManager() {
            try {
                return Caching.getCachingProvider().getCacheManager(((Object)((Object)this)).getClass().getResource("/jsr107/ehcache.xml").toURI(), JSR107Cache.class.getClassLoader());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

